import { DefaultTasksRunnerOptions } from './default-tasks-runner';
import { Batch } from './tasks-schedule';
import { BatchResults } from './batch/batch-messages';
import { Task, TaskGraph } from '../config/task-graph';
export declare class ForkedProcessTaskRunner {
    private readonly options;
    workspaceRoot: string;
    cliPath: string;
    private readonly verbose;
    private processes;
    constructor(options: DefaultTasksRunnerOptions);
    forkProcessForBatch({ executorName, taskGraph: batchTaskGraph }: Batch, fullTaskGraph: TaskGraph): Promise<BatchResults>;
    forkProcessPipeOutputCapture(task: Task, { streamOutput, temporaryOutputPath, taskGraph, }: {
        streamOutput: boolean;
        temporaryOutputPath: string;
        taskGraph: TaskGraph;
    }): Promise<{
        code: number;
        terminalOutput: string;
    }>;
    forkProcessDirectOutputCapture(task: Task, { streamOutput, temporaryOutputPath, taskGraph, }: {
        streamOutput: boolean;
        temporaryOutputPath: string;
        taskGraph: TaskGraph;
    }): Promise<{
        code: number;
        terminalOutput: string;
    }>;
    private readTerminalOutput;
    private writeTerminalOutput;
    private getEnvVariablesForProcess;
    private getEnvVariablesForTask;
    private getNxEnvVariablesForForkedProcess;
    private getNxEnvVariablesForTask;
    private getDotenvVariablesForForkedProcess;
    private getDotenvVariablesForTask;
    private signalToCode;
    private setupProcessEventListeners;
}
