"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initTasksRunner = void 0;
const tslib_1 = require("tslib");
const workspace_configuration_check_1 = require("../utils/workspace-configuration-check");
const configuration_1 = require("../config/configuration");
const project_graph_1 = require("../project-graph/project-graph");
const run_command_1 = require("./run-command");
const invoke_runner_terminal_output_life_cycle_1 = require("./life-cycles/invoke-runner-terminal-output-life-cycle");
const perf_hooks_1 = require("perf_hooks");
function initTasksRunner(nxArgs) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        perf_hooks_1.performance.mark('init-local');
        (0, workspace_configuration_check_1.workspaceConfigurationCheck)();
        const nxJson = (0, configuration_1.readNxJson)();
        if (nxArgs.verbose) {
            process.env.NX_VERBOSE_LOGGING = 'true';
        }
        const projectGraph = yield (0, project_graph_1.createProjectGraphAsync)({ exitOnError: true });
        return {
            invoke: (opts) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                perf_hooks_1.performance.mark('code-loading:end');
                const lifeCycle = new invoke_runner_terminal_output_life_cycle_1.InvokeRunnerTerminalOutputLifeCycle(opts.tasks);
                const taskGraph = {
                    roots: opts.tasks.map((task) => task.id),
                    tasks: opts.tasks.reduce((acc, task) => {
                        acc[task.id] = task;
                        return acc;
                    }, {}),
                    dependencies: opts.tasks.reduce((acc, task) => {
                        acc[task.id] = [];
                        return acc;
                    }, {}),
                };
                const status = yield (0, run_command_1.invokeTasksRunner)({
                    tasks: opts.tasks,
                    projectGraph,
                    taskGraph,
                    lifeCycle,
                    nxJson,
                    nxArgs: Object.assign(Object.assign({}, nxArgs), { parallel: opts.parallel }),
                    loadDotEnvFiles: true,
                    initiatingProject: null,
                });
                return {
                    status,
                    taskGraph,
                };
            }),
        };
    });
}
exports.initTasksRunner = initTasksRunner;
