"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNxCloudToken = exports.getNxCloudUrl = exports.isNxCloudUsed = void 0;
const configuration_1 = require("../config/configuration");
function isNxCloudUsed() {
    const nxJson = (0, configuration_1.readNxJson)();
    return Object.values(nxJson.tasksRunnerOptions).find((r) => r.runner == '@nrwl/nx-cloud' || r.runner == 'nx-cloud');
}
exports.isNxCloudUsed = isNxCloudUsed;
function getNxCloudUrl() {
    const taskRunner = isNxCloudUsed();
    if (!taskRunner)
        throw new Error('nx-cloud runner not find in nx.json');
    return taskRunner.options.url || 'https://nx.app';
}
exports.getNxCloudUrl = getNxCloudUrl;
function getNxCloudToken() {
    const taskRunner = isNxCloudUsed();
    if (!taskRunner)
        throw new Error('nx-cloud runner not find in nx.json');
    return taskRunner.options.accessToken;
}
exports.getNxCloudToken = getNxCloudToken;
