"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TempFs = void 0;
const tslib_1 = require("tslib");
const path_1 = require("path");
const os_1 = require("os");
const fs_extra_1 = require("fs-extra");
const path_2 = require("../path");
const fs_1 = require("fs");
class TempFs {
    constructor(dirname, overrideWorkspaceRoot = true) {
        this.dirname = dirname;
        this.tempDir = (0, fs_extra_1.mkdtempSync)((0, path_1.join)((0, os_1.tmpdir)(), this.dirname));
        if (overrideWorkspaceRoot) {
            process.env.NX_WORKSPACE_ROOT_PATH = this.tempDir;
        }
    }
    createFiles(fileObject) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield Promise.all(Object.keys(fileObject).map((path) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                yield this.createFile(path, fileObject[path]);
            })));
        });
    }
    createFilesSync(fileObject) {
        for (let path of Object.keys(fileObject)) {
            this.createFileSync(path, fileObject[path]);
        }
    }
    createFile(filePath, content) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield (0, fs_extra_1.outputFile)((0, path_2.joinPathFragments)(this.tempDir, filePath), content);
        });
    }
    createFileSync(filePath, content) {
        (0, fs_extra_1.outputFileSync)((0, path_2.joinPathFragments)(this.tempDir, filePath), content);
    }
    readFile(filePath) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return yield (0, fs_extra_1.readFile)(filePath, 'utf-8');
        });
    }
    removeFileSync(filePath) {
        (0, fs_extra_1.unlinkSync)((0, path_2.joinPathFragments)(this.tempDir, filePath));
    }
    appendFile(filePath, content) {
        (0, fs_1.appendFileSync)((0, path_2.joinPathFragments)(this.tempDir, filePath), content);
    }
    writeFile(filePath, content) {
        (0, fs_1.writeFileSync)((0, path_2.joinPathFragments)(this.tempDir, filePath), content);
    }
    renameFile(oldPath, newPath) {
        (0, fs_1.renameSync)((0, path_2.joinPathFragments)(this.tempDir, oldPath), (0, path_2.joinPathFragments)(this.tempDir, newPath));
    }
    cleanup() {
        (0, fs_extra_1.rmSync)(this.tempDir, { recursive: true });
    }
    reset() {
        (0, fs_extra_1.emptyDirSync)(this.tempDir);
    }
}
exports.TempFs = TempFs;
