import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  {
    path: 'login',
    loadChildren: () =>
      import('./pages/login/login.module').then(m => m.LoginPageModule)
  },
  {
    path: '',
    redirectTo: 'login',
    pathMatch: 'full'
  },
  {
    path: 'tabs',
    loadChildren: () =>
      import('./pages/tabs/tabs.module').then(m => m.TabsPageModule)
  },
  {
    path: 'categories',
    loadChildren: () =>
      import('./pages/categories/categories.module').then(m => m.CategoriesPageModule)
  },
  {
    path: 'edit-animal',
    loadChildren: () =>
      import('./pages/edit-animal/edit-animal.module').then(m => m.EditAnimalPageModule)
  },
  {
    path: 'select-dam-sire',
    loadChildren: () =>
      import('./pages/select-dam-sire/select-dam-sire.module').then(m => m.SelectDamSirePageModule)
  },
  {
    path: 'actions-filter',
    loadChildren: () =>
      import('./pages/actions-filter/actions-filter.module').then(m => m.ActionsFilterPageModule)
  },
  {
    path: 'search-criteria',
    loadChildren: () =>
      import('./pages/search-criteria/search-criteria.module').then(m => m.SearchCriteriaPageModule)
  },
  {
    path: 'search-groups-categories',
    loadChildren: () =>
      import('./pages/search-groups-categories/search-groups-categories.module').then(m => m.SearchGroupsCategoriesPageModule)
  },
  {
    path: 'animal-change',
    loadChildren: () => import('./pages/animal-change/animal-change.module').then(m => m.AnimalChangePageModule)
  },
  {
    path: 'reports-result',
    loadChildren: () => import('./pages/reports-result/reports-result.module').then(m => m.ReportsResultPageModule)
  },
  {
    path: 'select-bull',
    loadChildren: () => import('./pages/select-bull/select-bull.module').then(m => m.SelectBullPageModule)
  },
  {
    path: 'reports-modal',
    loadChildren: () => import('./pages/reports-modal/reports-modal.module').then(m => m.ReportsModalPageModule)
  }
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule { }
