import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router, NavigationExtras } from '@angular/router';
import { DataService } from 'src/app/services/data.service';
import { AddService } from 'src/app/services/add.service';
import { SearchCriteriaPage } from '../search-criteria/search-criteria.page';
import { ModalController } from '@ionic/angular';

@Component({
  selector: 'app-actions-filter',
  templateUrl: './actions-filter.page.html',
  styleUrls: ['./actions-filter.page.scss'],
})
export class ActionsFilterPage implements OnInit {
  public filteredGroups: any = [];
  public sexType: string = '';
  public selectedLength: number = 0;
  public selectAllFlag: string = "unchecked";
  public filter: any;
  public filteredAnimals: any = []
  public criteria: any;
  public appliedFilters: any = [];
  public groupSelected: any = [];
  private animals: any = [];
  private groups: any = [];
  private selected: any = [];
  private itemType: string = '';

  constructor(
    private router: Router,
    private dataService: DataService,
    private addService: AddService,
    private route: ActivatedRoute,
    private modalCtrl: ModalController
  ) { }

  // Show animals from the group the user selected from the 'animalsByGroup' action via Actions page
  showAnimals() {
    this.router.navigate([`/tabs/home/manage/group-animals/${this.groupSelected.id}/${this.groupSelected.group_name}/actions`]);
  }

  /*
  * Clear all applied filters
  * Reset filtered animals to list of all animals
  */
  clearFilters() {
    this.filteredAnimals = this.animals;
    this.criteria = null;
  }

  // Apply filter criteria to list of animals or groups
  applyFilterCriteria(criteria: any) {
    console.log('applyFilterCriteria');
    this.appliedFilters = [];

    if (this.animals.length > 0) {
      this.filteredAnimals = this.filterAnimals(criteria);
    } else if (this.groups.length > 0) {
      this.filteredGroups = this.filterGroups(criteria);
    } else {
      console.log('No animals or groups!');
    }
  }

  filterAnimals(criteria: any): any[] {
    let filteredAnimals = [...this.animals];

    for (const key in criteria) {
      switch (key) {
        case 'primaryID':
          if (criteria[key]) {
            filteredAnimals = filteredAnimals.filter(item => item.primary_id.toLowerCase().includes(criteria[key].toLowerCase()));
            this.appliedFilters.push(` Primary ID Contains: ${criteria[key]};`);
          }
          break;
        case 'sexID':
          if (criteria[key]) {
            filteredAnimals = filteredAnimals.filter(item => (+item.sex_id === +criteria[key]));
            this.appliedFilters.push(` Sex: ${criteria[key]};`);
          }
          break;
        case 'birthStartDate':
          if (criteria[key]) {
            const startDate = criteria[key];
            filteredAnimals = filteredAnimals.filter(item => item.date_birth >= startDate);
            this.appliedFilters.push(` Birth Start Date >= ${criteria[key]};`);
          }
          break;
        case 'birthEndDate':
          if (criteria[key]) {
            const endDate = criteria[key];
            filteredAnimals = filteredAnimals.filter(item => item.date_birth <= endDate);
            this.appliedFilters.push(` Birth End Date <= ${criteria[key]};`);
          }
          break;
        case 'purchaseStartDate':
          if (criteria[key]) {
            const startDate = criteria[key];
            filteredAnimals = filteredAnimals.filter(item => item.date_purchase >= startDate);
            this.appliedFilters.push(` Purchase Start Date >= ${criteria[key]};`);
          }
          break;
        case 'purchaseEndDate':
          if (criteria[key]) {
            const endDate = criteria[key];
            filteredAnimals = filteredAnimals.filter(item => item.date_purchase <= endDate);
            this.appliedFilters.push(` Purchase End Date <= ${criteria[key]};`);
          }
          break;
        case 'groupIDs':
          if (criteria[key]) {
            filteredAnimals = filteredAnimals.filter(item => criteria[key].includes(+item.group_ids));
            this.appliedFilters.push(` Group IDs: ${criteria[key]};`);
          }
          break;
        case 'categoryIDs':
          if (criteria[key]) {
            filteredAnimals = filteredAnimals.filter(item => (+item.category_ids === +criteria[key]));
            this.appliedFilters.push(` Category IDs: ${criteria[key]};`);
          }
          break;
      }
    }

    return filteredAnimals;
  }

  filterGroups(criteria: any): any[] {
    let filteredGroups = [...this.groups];

    for (const key in criteria) {
      switch (key) {
        case 'groupName':
          if (criteria[key]) {
            filteredGroups = filteredGroups.filter(item => item.group_name.toLowerCase().includes(criteria[key].toLowerCase()));
            this.appliedFilters.push(` Group Name contains: ${criteria[key]};`);
          }
          break;
        case 'amountAnimals':
          if (criteria[key]) {
            filteredGroups = filteredGroups.filter(item => (+item.amount_animals === +criteria[key]));
            this.appliedFilters.push(` Amount of Animals: ${criteria[key]};`);
          }
          break;
        case 'categoryIDs':
          if (criteria[key]) {
            filteredGroups = filteredGroups.filter(item => (+item.category_ids === +criteria[key]));
            this.appliedFilters.push(` Category IDs: ${criteria[key]};`);
          }
          break;
      }
    }

    return filteredGroups;
  }


  // Open Search Criteria page to let the user define a filter for available items
  async searchCriteria() {
    const modal = await this.modalCtrl.create({
      component: SearchCriteriaPage,
      componentProps: {
        itemType: this.itemType,
        page: 'record'
      }
    });

    modal.onDidDismiss()
      .then((data: any) => {
        if (data.data) {
          console.log(data.data);
          this.filteredAnimals = this.animals;
          console.log(this.filteredAnimals);
          this.filteredGroups = this.groups;
          console.log(this.filteredGroups);
          this.criteria = data.data;
          console.log(this.criteria);

          this.applyFilterCriteria(this.criteria);
        }
      })
      .catch((error: any) => {
        console.log('Actions Modal Search Criteria Error', error);
      });

    return await modal.present();
  }

  /*
  * Once the user has added some items into the temporary list
  * Continue to the next page which will allow them to select from a list of actions
  */
  actionsSelect() {
    /*
    * Pass temporary list of selected items to "Actions Select" page
    * This page will allow the user to select an action to apply to the temporary list of selected items
    */
    const navigationExtras: NavigationExtras = {
      state: {
        itemType: this.itemType,
        selected: this.selected,
        filter: this.filter
      }
    };

    this.router.navigate(['/tabs/home/actions/actions-select'], navigationExtras);
  }

  // implement search bar to search by group name of groups
  searchBar(event: any) {
    return this.filteredGroups = this.groups.filter((group: any) =>
      group.group_name.toLowerCase().indexOf(event.detail.value.toLowerCase()) > -1);
  }

  // Select all current list items
  selectAll(event: any) {

    let items = this.filteredAnimals;

    if (items) {
      /*
      * True/false for event checked is backwards???
      * False means it is checked, true means it is unchecked
      * If, Select All is checked/tapped (false); set current as true; append to list
      * Else, Select All is unchecked (true); unchecked all and clear list
      */
      if (!event.target.checked) {
        this.selectAllFlag = 'checked';

        /*
        * Iterate through items and set all to checked
        * Push to list of selected items if they are not already in the list
        */
        for (const i of items) {
          i.isChecked = true;
          if (!this.selected.includes(i)) {
            this.selected.push(i);
          }
        }

      } else if (event.target.checked) {
        // Else if, the user taps "Deselect All", all value are removed from list
        this.selectAllFlag = 'unchecked';

        // Uncheck/deselect all items
        for (const i of items) {
          i.isChecked = false;
        }

        // Set list of selected items to empty
        this.selected = [];
      }

      // Update current length of selected (used to enable/disable 'Continue' button)
      this.selectedLength = this.selected.length;
    }
  }

  // Detect when a checkbox for a group has been selected/deselected; adjust our selected list as needed
  checkboxChanged(selection: any) {
    console.log(selection);
    const index = this.selected.findIndex((item: { id: any; }) => item.id === selection.id);

    if (index !== -1) {
      // Item found, remove it from the array
      this.selected.splice(index, 1);
    } else {
      // Item not found, add it to the array
      this.selected.push(selection);
    }

    // Update current length of selected (used to enable/disable 'Continue' button)
    this.selectedLength = this.selected.length;
  }

  // itemSelectAllClicked() {
  //   console.log(this.isAllSelected);
  //   console.log('itemSelectAllClicked');
  //   // Toggle the global isAllSelected state
  //   this.isAllSelected = !this.isAllSelected;

  //   // Update the list based on the new state
  //   this.updateSelection(this.isAllSelected);
  // }

  // checkboxChange(event: any) {
  //   // Update the global isAllSelected state
  //   this.isAllSelected = event.detail.checked;

  //   // Update the list based on the new state
  //   this.updateSelection(this.isAllSelected);
  // }

  // updateSelection(isSelected: boolean) {
  //   console.log('updateSelection');
  //   console.log(isSelected);
  //   let items: any;
  //   if (this.filter.toLowerCase().includes('animals')) {
  //     items = this.filteredAnimals;
  //   } else if (this.filter.toLowerCase().includes('groups')) {
  //     items = this.filteredGroups;
  //   }

  //   if (isSelected) {
  //     // Select all items
  //     items.forEach((i: { isChecked: boolean; }) => {
  //       i.isChecked = true;
  //       if (!this.selected.includes(i)) {
  //         this.selected.push(i);
  //       }
  //     });
  //   } else {
  //     // Deselect all items
  //     items.forEach((i: { isChecked: boolean; }) => {
  //       i.isChecked = false;
  //     });
  //     this.selected = [];
  //   }
  //   this.selectedLength = this.selected.length;
  // }


  // checkboxSelectAllClicked(event: MouseEvent) {
  //   // Trigger the selection logic for the checkbox click
  //   this.itemSelectAllClicked();

  //   // Prevent the event from bubbling up to the ion-item
  //   event.stopPropagation();
  // }

  // selectAll(event: any) {
  //   this.isAllSelected = event.detail.checked; // This directly gives us the checkbox state

  //   let items: any;
  //   if (this.filter.toLowerCase().includes('animals')) {
  //     items = this.filteredAnimals;
  //   } else if (this.filter.toLowerCase().includes('groups')) {
  //     items = this.filteredGroups;
  //   }

  //   if (this.isAllSelected) {
  //     // Select all items
  //     items.forEach((i: { isChecked: boolean; }) => {
  //       i.isChecked = true;
  //       if (!this.selected.includes(i)) {
  //         this.selected.push(i);
  //       }
  //     });
  //   } else {
  //     // Deselect all items
  //     items.forEach((i: { isChecked: boolean; }) => {
  //       i.isChecked = false;
  //     });
  //     this.selected = [];
  //   }
  //   this.selectedLength = this.selected.length;
  // }

  // animalItemClicked(selection: any) {
  //   // Toggle the checkbox when the item is clicked
  //   selection.isChecked = !selection.isChecked;

  //   // Create a mock event detail to simulate the checkbox change event
  //   const mockEvent = {
  //     detail: {
  //       checked: selection.isChecked
  //     }
  //   };

  //   this.checkboxChanged(mockEvent, selection);
  // }

  // checkboxDirectClick(event: MouseEvent) {
  //   // Prevent the event from propagating up to the ion-item, 
  //   // thus preventing double-invocation
  //   event.stopPropagation();
  // }

  // checkboxAnimalChanged(event: any, selection: any) {
  //   this.checkboxChanged(event, selection);
  // }

  // checkboxChanged(event: any, selection: any) {
  //   const isChecked = event.detail.checked;

  //   if (isChecked) {
  //     if (!this.selected.includes(selection)) {
  //       this.selected.push(selection);
  //     }
  //   } else {
  //     const index = this.selected.indexOf(selection);
  //     if (index >= 0) {
  //       this.selected.splice(index, 1);
  //     }
  //   }

  //   this.selectedLength = this.selected.length;
  //   console.log('Selected Length:', this.selectedLength)
  // }


  // groupItemClicked(selection: any) {
  //   // Toggle the checkbox when the item is clicked
  //   selection.isChecked = !selection.isChecked;

  //   // Create a mock event detail to simulate the checkbox change event
  //   const mockEvent = {
  //     detail: {
  //       checked: selection.isChecked
  //     }
  //   };

  //   this.checkboxChanged(mockEvent, selection);
  // }


  // checkboxGroupChanged(event: any, selection: any) {
  //   this.checkboxChanged(event, selection);
  // }


  // singleCheckboxChanged(group: any) {
  //   // if we already have a value for selected (previous selection)
  //   if (this.groupSelected) {

  //     // if the category selected by the user is the same as our previously selected value
  //     if (group.id === this.groupSelected.id) {

  //       // check to see if our selected value is "checked" aka un-checked
  //       if (this.groupSelected.isChecked) {

  //         // if so, set selected value to null
  //         this.groupSelected = null;
  //       } else if (!this.groupSelected.isChecked) {
  //         /*
  //         * Else if our selected value is "not checked" aka checked
  //             set our new selected value equal to the category the user selected
  //         */
  //         this.groupSelected = group;
  //       }
  //     } else {
  //       /*
  //       * Else, the category selected by the user is not the same as our previously selected value
  //           un-check our current selected value and set new selected value to category
  //       */
  //       this.groupSelected.isChecked = false;
  //       this.groupSelected = group;
  //     }
  //   } else {
  //     // Else, we do not have a selected value, set it to the passed category (user selected)
  //     this.groupSelected = group;
  //   }
  // }


  ionViewDidEnter() {
    /*
    * When the page enters the view...
    * Reset length of selected items back to 0, so we do not count previously selected items
    */
    this.selected = [];
    this.selectedLength = 0;

    if (this.itemType === 'animals') {
      this.dataService.get('getAllAnimals', null)
        .then((data: any) => {
          if (data && data.length > 0) {
            this.dataService.presentLoading();
            /*
            * Filter animals to only display those with status ID 1 "Active"
            * Users are not allowed to record data for animals which are "Inactive" (2)
            */
            this.animals = data.filter((s: any) => s.status_id === 1);
            this.filteredAnimals = this.animals;
          } else {
            this.addService.displayAlert('Actions All Animals Error',
              'An error occurred while retrieving data. Please check network connection and try again.');
          }
        })
        .catch((error: any) => {
          console.log(`Actions All Animals Error: ${error}`);
        });
    } else if (this.itemType === 'groups') {
      this.dataService.get('getGroups', null)
        .then((data: any) => {
          if (data && data.length > 0) {
            this.groups = data;

            /*
            * Iterate through list of groups and find groups that have animals
            * Push them into `filteredGroups` list to be displayed on screen
            */
            for (const g of this.groups) {
              if (g.amount_animals > 0) {
                this.filteredGroups.push(g);
              }
            }

            // Present loading spinner after groups have been filtered to only those with animals
            if (this.filteredGroups?.length > 0) {
              this.dataService.presentLoading();
            }
          } else {
            this.addService.displayAlert('Actions All Groups Error',
              'An error occurred while retrieving data. Please check network connection and try again.');
          }
        })
        .catch((error: any) => {
          console.log(`Actions All Groups Error: ${error}`);
        });
    }
  }

  /*
  * NEED TO FIX THIS ???
  * NOTE: when the user clicks back from the Actions Continue page,
      then Actions Filter page does not have the previous items
      checked even though they still have checked status
  */
  ngOnInit() {
    if (this.route.snapshot.paramMap.get('filter')) {
      console.log(this.route.snapshot.paramMap.get('filter'));
      this.filter = this.route.snapshot.paramMap.get('filter');

      if (this.filter.toLowerCase().includes('group')) {
        this.itemType = 'groups';
      } else if (this.filter.toLowerCase().includes('animals')) {
        this.itemType = 'animals';
      } else {
        console.log('Actions Filter: No useful filter.');
        this.router.navigateByUrl('/tabs/home');
      }
    } else {
      console.log('Actions Filter: No passed `filter` parameter.');
      this.router.navigateByUrl('/tabs/home');
    }
  }

}
