import { Component, OnInit } from '@angular/core';
import { DataService } from 'src/app/services/data.service';
import { AddService } from 'src/app/services/add.service';
import { Router, ActivatedRoute } from '@angular/router';

@Component({
  selector: 'app-add-existing',
  templateUrl: './add-existing.page.html',
  styleUrls: ['./add-existing.page.scss'],
})
export class AddExistingPage implements OnInit {
  public animals: any = [];
  public selectedTemporary: any;
  public selectAllFlag = 'unchecked';
  public filteredAnimals: any = [];
  public selectedAnimalIDs: any = [];
  // Variable to hold length of current selected list (used to enable/disabled 'Continue' button)
  public selectedLength = this.selectedAnimalIDs.length;
  private groupID: number = -1;
  private groupName: string = '';

  constructor(
    private route: ActivatedRoute,
    private router: Router,
    private dataService: DataService,
    private addService: AddService
  ) {
    this.route.queryParams.subscribe(() => {
      if (this.router.getCurrentNavigation()?.extras.state) {
        this.groupID = +this.router.getCurrentNavigation()?.extras.state?.['id'];
        this.groupName = this.router.getCurrentNavigation()?.extras.state?.['name'];
      }
    });
  }

  // Send selected animal IDs to server to add to group
  addAnimals() {
    if (this.selectedAnimalIDs && this.selectedLength > 0) {
      this.dataService.addExistingAnimalsToGroup(this.groupID, this.selectedAnimalIDs)
        .then((response: any) => {
          console.log(`addAnimals() addExistingAnimalsToGroup response: ${response}`);
          if (response) {
            this.addService.showToast('The existing animals you selected have been successfully added to the group.');
            this.router.navigateByUrl(`/tabs/home/manage/group-animals/${this.groupID}/${this.groupName}/0`);
          } else {
            this.addService.displayAlert('Add Animals Error',
              'An error occurred while adding animals. Check your network connection and try again.');
          }
        })
        .catch((error: any) => {
          console.log(`addAnimals() addExistingAnimalsToGroup error: ${error}`);
          this.addService.displayAlert('Add Animals Error',
            'An error occurred while adding animals. Check your network connection and try again.');
        });
    } else {
      this.addService.displayAlert('No Animals Selected',
        'Cannot add animals because no animals were selected. Please try again.');
    }
  }

  // Filter animals based on primary ID (name)
  filterAnimals(event: any) {
    const searchTerm = event.target.value;

    if (searchTerm) {
      return this.filteredAnimals = this.animals.filter((animal: any) =>
        animal.primary_id.toLowerCase().indexOf(searchTerm.toLowerCase()) > -1);
    } else {
      return this.filteredAnimals = this.animals;
    }
  }

  // Detect when a checkbox for a group has been selected/deselected; adjust our selectedAnimals list as needed
  checkboxChanged(selectedID: any, event: any) {
    console.log('checkboxChanged');
    if (event.detail.checked) {
      if (!this.selectedAnimalIDs.includes(selectedID)) {
        this.selectedAnimalIDs.push(selectedID);
      }
    } else {
      const selectionIndex = this.selectedAnimalIDs.indexOf(selectedID);
      if (selectionIndex !== -1) {
        this.selectedAnimalIDs.splice(selectionIndex, 1);
      }
    }

    // Update current length of selected (used to enable/disable 'Add' button)
    this.selectedLength = this.selectedAnimalIDs.length;
    console.log(this.selectedAnimalIDs);
    console.log(this.selectedAnimalIDs.length);
  }


  // When the user taps "Select All" for the currently listed items on the screen
  selectAll(event: any) {
    /*
    * Is the True/False for event checked backwards?
    * False means it is checked, True means it is unchecked
    * If, `Select All` is checked/tapped (false); set current filtered group as true; append to list
    * Else, `Select All` is unchecked (true); unchecked all group and clear list
    */
    if (!event.target.checked) {
      this.selectAllFlag = 'checked';

      // Iterate through the list of filtered groups
      for (const animal of this.filteredAnimals) {
        // Set each group to checked
        animal.isChecked = true;
        // If our selected list already has the animal id; do nothing and continue
        // Else, add animal ID to list
        if (this.selectedAnimalIDs.includes(animal.id)) {
          continue;
        } else {
          this.selectedAnimalIDs.push(animal.id);
        }
      }
    } else if (event.target.checked) {
      this.selectAllFlag = 'unchecked';
      for (const animal of this.filteredAnimals) {
        animal.isChecked = false;
        this.selectedAnimalIDs = [];
      }
    }

    // Update current length of selected (used to enable/disable 'Add' button)
    this.selectedLength = this.selectedAnimalIDs.length;
  }

  ionViewDidEnter() {
    if (this.groupID) {
      this.dataService.get('getExistingAnimals', this.groupID)
        .then((data: any) => {
          if (data && data.length > 0) {
            // Present loading spinner
            this.dataService.presentLoading();

            // Set `animals` to data
            this.animals = data;

          } else {
            this.animals = [];
          }

          // Set `filteredAnimals` to `animals`
          this.filteredAnimals = this.animals;

        })
        .catch((error: any) => {
          this.animals = [];
          this.filteredAnimals = this.animals;
        });
    } else {
      this.addService.displayAlert('Unknown Group ID',
        'An error occurred while trying to determine the ID of the group we are adding animals to. ' +
        'Check your network connection and try again.');
      this.router.navigateByUrl('/tabs/home');
    }
  }

  ngOnInit() { }

}
