import { Component, OnInit } from '@angular/core';
import { ModalController } from '@ionic/angular';

@Component({
  selector: 'app-animal-change',
  templateUrl: './animal-change.page.html',
  styleUrls: ['./animal-change.page.scss'],
})
export class AnimalChangePage implements OnInit {
  public selected: any;
  public selectedAnimals: any;
  public filteredAnimals: any;
  public currentAnimal: any;

  constructor(
    private modalCtrl: ModalController
  ) { }

  // Filter animals based on primary ID (name)
  filter(event: any) {
    const searchTerm = event.target.value;

    if (searchTerm) {
      return this.filteredAnimals = this.selectedAnimals.filter((animal: any) =>
        animal.primary_id.toLowerCase().indexOf(searchTerm.toLowerCase()) > -1);
    } else {
      return this.filteredAnimals = this.selectedAnimals;
    }
  }

  checkboxChanged(animal: string) {
    // If there is already value for selected (previous selection)
    if (this.selected) {

      // If the animal selected by the user is the same as our previously selected value
      if (animal === this.selected) {

        // If the selected value is "checked" aka un-checked
        if (this.selected.isChecked) {

          // If so, set selected value to null
          this.selected = null;
        } else if (!this.selected.isChecked) {

          /*
          * Else if our selected value is "not checked" aka checked
          * Set our new selected value equal to the animal the user selected
          */
          this.selected = animal;
        }
      } else {

        /*
        * Else, the animal selected by the user is not the same as our previously selected value
        * "Un-check" our current selected value and set new selected value to animal
        */
        this.selected.isChecked = false;
        this.selected = animal;
      }
    } else {

      /*
      * Else, there is not a selected value
      * Set it to the passed animal
      */
      this.selected = animal;
    }
  }

  /*
  * If the user taps "Done"/"Close", the modal will be dismissed and the Animals will be returned
  * In the case there are no Animals, Null is returned instead
  */
  dismiss(save: boolean = false) {
    if (save) {
      this.modalCtrl.dismiss(this.selectedAnimals);
    } else {
      this.modalCtrl.dismiss(null);
    }
  }

  ngOnInit() {
    console.log('selectedAnimals:', this.selectedAnimals);

    /* 
    * The selected animals currently have an "isChecked" flag set to true, set this back to false
    * That way, the selected animals are not checked when the "Animal Change" modal page is displayed
    */
    for (const animal of this.selectedAnimals) {
      animal.isChecked = false;
    }

    // Initialize list of filtered animals equal to the passed current list of selected animals
    this.filteredAnimals = this.selectedAnimals;

  }

}
