import { Component, OnInit } from '@angular/core';
import { AccountService } from 'src/app/services/account.service';

@Component({
  selector: 'app-home',
  templateUrl: './home.page.html',
  styleUrls: ['./home.page.scss'],
})
export class HomePage implements OnInit {

  // Initialize variable to hold user's ID (`extID`)
  public userID: any;

  constructor(
    private accountService: AccountService
  ) { }

  /*
  * If the user taps `Logout` in the upper left corner or there is an error
      processing if they are logged in when the page first loads then
      proceed with the logout function from the Account service and redirect the user to the login page
  */
  logout() {
    this.accountService.logout();
  }

  // When the page loads, check to see if the user is logged in via the Account service
  ngOnInit() {
    this.accountService.checkLogin('home')
      .then((value: any) => {
        /*
        * If there is a value for the current user's `extID` in local storage, then they are logged in
        * Set value for the current page to reflect this status (button in right corner)
        */
        if (value) {
          this.userID = value;
        } else {
          // Otherwise, if there is not a value, then default to logout and return to Login page
          this.logout();
        }
      });
  }

}
