import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { AccountService } from 'src/app/services/account.service';
import { Browser } from '@capacitor/browser';

@Component({
  selector: 'app-login',
  templateUrl: './login.page.html',
  styleUrls: ['./login.page.scss'],
})
export class LoginPage implements OnInit {

  public loginForm: FormGroup;

  constructor(
    public formBuilder: FormBuilder,
    private accountService: AccountService
  ) {
    this.loginForm = formBuilder.group({
      email: new FormControl('', [Validators.required, Validators.email]),
      password: new FormControl('', Validators.required)
    });
  }

  /*
  * Open in-app browser with passed URL
  * Bring up the extension account webpage for `Forgot Password` or `Create Account`
  */
  async browser(url: string) {
    await Browser.open({ url });
  }

  login() {
    /*
    * Trim any whitespace from input values for email and password
    * If the email and password have values, pass data to service
    */
    const email = this.loginForm.controls['email'].value.trim();
    const password = this.loginForm.controls['password'].value.trim();

    if (email && password) {
      this.accountService.login(email, password);
    }
  }

  // When the page loads, check to see if the user is logged in
  ngOnInit() {
    this.accountService.checkLogin('login');
  }

}
