import { Component, OnInit } from '@angular/core';
import { ModalController } from '@ionic/angular';
import { AddService } from 'src/app/services/add.service';
import { DataService } from 'src/app/services/data.service';
import { SearchCriteriaPage } from '../search-criteria/search-criteria.page';

@Component({
  selector: 'app-reports-modal',
  templateUrl: './reports-modal.page.html',
  styleUrls: ['./reports-modal.page.scss'],
})
export class ReportsModalPage implements OnInit {
  public selectedLength: number = 0;
  public selectAllFlag: string = 'unchecked';
  public filteredGroups: any = [];
  public groups: any = [];
  public animals: any = [];
  public filteredAnimals: any = [];
  public selected: any = [];
  public searchType: any;
  public criteria: any;
  public itemType: any;
  public appliedFilters: any = [];

  constructor(
    private dataService: DataService,
    private addService: AddService,
    private modalCtrl: ModalController
  ) { }

  // Apply filter criteria to list of animals or groups
  applyFilterCriteria(criteria: any) {
    console.log('applyFilterCriteria');

    // Reset list of `appliedFilters` to empty
    this.appliedFilters = [];

    // Initialize list of items (`myList`) to empty
    let myList = [];

    if (this.animals.length > 0) {

      // Set `myList` equal to the full list of animals (later filtered based on selected filter criteria)
      myList = this.animals;

      // If, `myList` has values (animals), iterate through the different criteria and filter list down to appropriate animals
      if (myList.length > 0) {
        for (const key in criteria) {
          if (key === 'primaryID' && criteria[key]) {
            myList = myList.filter((item: any) => item.primary_id.toLowerCase().indexOf(criteria[key].toLowerCase()) > -1);
            this.appliedFilters.push(` Primary ID Contains: ${criteria[key]};`);
          }

          if (key === 'sexID' && criteria[key]) {
            myList = myList.filter((item: any) => (+item.sex_id === +criteria[key]));
            this.appliedFilters.push(` Sex: ${criteria.sex};`);
          }

          if (key === 'birthStartDate' && criteria[key]) {
            const startDate = criteria[key];
            myList = myList.filter((item: any) => {
              if (item.date_birth >= startDate) {
                return item.date_birth;
              }
            });
            this.appliedFilters.push(` Birth Start Date >= ${criteria[key]};`);
          }

          if (key === 'birthEndDate' && criteria[key]) {
            const endDate = criteria[key];
            myList = myList.filter((item: any) => {
              if (item.date_birth <= endDate) {
                return item.date_birth;
              }
            });
            this.appliedFilters.push(` Birth End Date <= ${criteria[key]};`);
          }

          if (key === 'purchaseStartDate' && criteria[key]) {
            const startDate = criteria[key];
            myList = myList.filter((item: any) => {
              if (item.date_purchase >= startDate) {
                return item.date_purchase;
              }
            });
            this.appliedFilters.push(` Purchase Start Date >= ${criteria[key]};`);
          }

          if (key === 'purchaseEndDate' && criteria[key]) {
            const endDate = criteria[key];
            myList = myList.filter((item: any) => {
              if (item.date_purchase <= endDate) {
                return item.date_purchase;
              }
            });
            this.appliedFilters.push(` Purchase End Date <= ${criteria[key]};`);
          }

          if (key === 'groupIDs' && criteria[key]) {
            myList = myList.filter((item: any) => (criteria[key].includes(+item.group_ids)));
            this.appliedFilters.push(` Group IDs: ${criteria[key]};`);
          }

          if (key === 'categoryIDs' && criteria[key]) {
            myList = myList.filter((item: any) => (+item.category_ids === +criteria[key]));
            this.appliedFilters.push(` Category IDs: ${criteria[key]};`);
          }
        }

        if (myList) {
          // Set list of filtered animals to list of animals with selected filtered applied
          this.filteredAnimals = myList;
        }

      }
    } else if (this.groups.length > 0) {
      myList = this.groups;

      if (myList.length > 0) {
        for (const key in criteria) {
          if (key === 'groupName' && criteria[key]) {
            myList = myList.filter((item: any) => item.group_name.toLowerCase().indexOf(criteria[key].toLowerCase()) > -1);
            this.appliedFilters.push(` Group Name contains: ${criteria[key]};`);
          }
          if (key === 'amountAnimals' && criteria[key]) {
            myList = myList.filter((item: any) => (+item.amount_animals === +criteria[key]));
            this.appliedFilters.push(` Amount of Animals: ${criteria[key]};`);
          }
          if (key === 'categoryIDs' && criteria[key]) {
            myList = myList.filter((item: any) => (+item.category_ids === +criteria[key]));
            this.appliedFilters.push(` Category IDs: ${criteria[key]};`);
          }
        }

        if (myList) {
          // Set list of filtered groups to list of groups with selected filtered applied
          this.filteredGroups = myList;
        }
      }

    } else {
      console.log('No animals or groups!');
    }
  }

  // Open Search Criteria page to let the user define a filter for available items
  async searchCriteria() {
    const modal = await this.modalCtrl.create({
      component: SearchCriteriaPage,
      componentProps: {
        itemType: this.searchType,
        page: 'reports'
      }
    });

    modal.onDidDismiss()
      .then((data: any) => {
        if (data.data) {
          console.log(`searchCriteria modal.onDidDismiss() data: ${data.data}`);
          this.filteredAnimals = this.animals;
          console.log(`searchCriteria modal.onDidDismiss() filteredAnimals: ${this.filteredAnimals}`);
          this.filteredGroups = this.groups;
          console.log(`searchCriteria modal.onDidDismiss() filteredGroups: ${this.filteredGroups}`);
          this.criteria = data.data;
          console.log(`searchCriteria modal.onDidDismiss() criteria: ${this.criteria}`);

          this.applyFilterCriteria(this.criteria);
        }
      })
      .catch((error: any) => {
        console.log('Actions Modal Search Criteria Error', error);
      });

    return await modal.present();
  }

  // Dismiss `Search Groups Categories` modal with selected item
  done() {
    this.modalCtrl.dismiss(this.selected);
  }

  // Dismiss `Search Groups Categories` modal
  dismiss() {
    this.modalCtrl.dismiss();
  }

  // Filter and return groups based on user input in search bar
  searchBar(event: any) {
    return this.filteredGroups = this.groups.filter((group: any) =>
      group.group_name.toLowerCase().indexOf(event.detail.value.toLowerCase()) > -1);
  }

  // Select all current list items
  selectAll(event: any) {

    let items = null;

    if (this.searchType === 'groups') {
      items = this.filteredGroups;
    } else if (this.searchType === 'animals') {
      items = this.filteredAnimals;
    }

    if (items) {
      /*
      * True/false for event checked is backwards???
      * False means it is checked, true means it is unchecked
      * If, Select All is checked/tapped (false); set current as true; append to list
      * Else, Select All is unchecked (true); unchecked all and clear list
      */
      if (!event.target.checked) {
        this.selectAllFlag = 'checked';

        /*
        * Iterate through items and set all to checked
        * Push to list of selected items if they are not already in the list
        */
        for (const i of items) {
          i.isChecked = true;
          if (!this.selected.includes(i)) {
            this.selected.push(i);
          }
        }

      } else if (event.target.checked) {
        // Else if, the user taps "Deselect All", all value are removed from list
        this.selectAllFlag = 'unchecked';

        // Uncheck/deselect all items
        for (const i of items) {
          i.isChecked = false;
        }

        // Set list of selected items to empty
        this.selected = [];
      }

      // Update current length of selected (used to enable/disable 'Continue' button)
      this.selectedLength = this.selected.length;
    }
  }

  // Detect when a checkbox for a group has been selected/deselected; adjust our selected list as needed
  checkboxChanged(selection: any) {
    console.log(selection);
    const index = this.selected.findIndex((item: { id: any; }) => item.id === selection.id);

    if (index !== -1) {
      // Item found, remove it from the array
      this.selected.splice(index, 1);
    } else {
      // Item not found, add it to the array
      this.selected.push(selection);
    }

    // Update current length of selected (used to enable/disable 'Continue' button)
    this.selectedLength = this.selected.length;
  }

  ionViewDidEnter() {
    console.log(this.searchType);

    if (this.searchType === 'groups') {
      // When the page enters the view, get all groups for the current user
      this.dataService.get('getGroups', null)
        .then((data: any) => {
          if (data && data.length > 0) {
            this.dataService.presentLoading();
            this.groups = data;
            this.filteredGroups = this.groups;
          }
        })
        .catch((error: any) => {
          console.log(`Search Groups Get Groups Error: ${error}`);
          this.addService.displayAlert('Search Groups Get Groups Error',
            'An error occurred while retrieving data. Please check network connection and try again.');
        });
    } else if (this.searchType === 'animals') {
      // When the page enters the view, get all animals for the current user
      this.dataService.get('getAllAnimals', null)
        .then((data: any) => {
          if (data && data.length > 0) {
            this.dataService.presentLoading();
            this.animals = data;
            this.filteredAnimals = this.animals;
          }
        })
        .catch((error: any) => {
          console.log(`Search Groups Get Groups Error: ${error}`);
          this.addService.displayAlert('Search Groups Get Groups Error',
            'An error occurred while retrieving data. Please check network connection and try again.');
        });
    }
  }

  ngOnInit() { }

}
