import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { ModalController } from '@ionic/angular';
import { ShareService } from '../../services/share.service';

@Component({
  selector: 'app-reports-result',
  templateUrl: './reports-result.page.html',
  styleUrls: ['./reports-result.page.scss'],
})
export class ReportsResultPage implements OnInit {
  public isSharing = false;
  public response: any;
  public reportType = '';

  private reportNames: { [key: string]: string } = {
    "birth": "Birth",
    "air": "Artificial Insemination",
    "bior": "Bull-In/Bull-Out",
    "nsbr": "Natural Service Breeding",
    "cpr": "Cow Progeny",
    "healthEvent": "Health Event",
    "customProcessing": "Custom Processing",
    "ped": "Pedigree",
    "unknown": "Unknown Sex",
    "inactive": "Inactive Status",
    "pcr": "Pregnancy Check",
    "ccir": "Cow-calf Inventory",
    "growth": "Growth Performance",
    "ccr": "Cow Calving",
    "weaning": "Weaning",
    "inventory": "Inventory",
  };

  constructor(
    private modalCtrl: ModalController,
    private router: Router,
    private shareService: ShareService
  ) { }

  async shareCSV() {
    try {
      const reportName = this.reportNames[this.reportType as keyof typeof this.reportNames] || "Invalid report type";
      this.isSharing = true;

      await this.shareService.generateAndShareCSV(reportName, this.response);

      console.log('Share successful');
      this.isSharing = false;
    } catch (error) {
      console.error(`Error creating CSV and sharing for ${this.reportType} report:`, error);
    }
  }

  dismiss() {
    if (this.reportType === 'unknown' || this.reportType === 'inactive' || this.reportType === 'inventory') {
      this.router.navigateByUrl('/tabs/reports');
    }
    this.modalCtrl.dismiss();
  }

  ngOnInit() {
    console.log(`Reports Result; reportType: ${this.reportType}`);
    console.log(`Reports Result; response: ${JSON.stringify(this.response)}`);
  }
}
