import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl } from '@angular/forms';
import { ModalController } from '@ionic/angular';
import { SearchGroupsCategoriesPage } from '../search-groups-categories/search-groups-categories.page';

type ViewType = 'groups' | 'categories';

enum StatusID {
  ACTIVE = 1,
  INACTIVE = 2,
}

enum SexID {
  BULL = 1,
  STEER = 2,
  COW = 3,
  UNKNOWN = 4,
}

@Component({
  selector: 'app-search-criteria',
  templateUrl: './search-criteria.page.html',
  styleUrls: ['./search-criteria.page.scss'],
})
export class SearchCriteriaPage implements OnInit {
  public searchCriteriaForm!: FormGroup;
  public itemType: any;
  public page: any;

  constructor(
    public formBuilder: FormBuilder,
    private modalCtrl: ModalController
  ) {
    this.initForm();
  }

  private initForm() {
    this.searchCriteriaForm = this.formBuilder.group({
      groupName: new FormControl(null),
      status: new FormControl(null),
      statusID: new FormControl(null),
      primaryID: new FormControl(null),
      sex: new FormControl(null),
      sexID: new FormControl(null),
      birthStartDate: new FormControl(null),
      birthEndDate: new FormControl(null),
      purchaseStartDate: new FormControl(null),
      purchaseEndDate: new FormControl(null),
      amountAnimals: new FormControl(null),
      groups: new FormControl(null),
      groupIDs: new FormControl(null),
      categories: new FormControl(null),
      categoryIDs: new FormControl(null)
    });
  }

  async searchGroupsCategories(view: ViewType) {
    console.log('searchGroupsCategories() view:', view);
    console.log('searchGroupCategories() create SearchGroupsCategoriesPage modal');

    const modal = await this.modalCtrl.create({
      component: SearchGroupsCategoriesPage,
      componentProps: {
        viewType: view
      }
    });

    modal.onDidDismiss()
      .then((data: any) => {
        if (data.data) {
          this.processReturnedData(data.data, view);
        }
      })
      .catch((error: any) => {
        console.log('Search Criteria, Search Groups / Categories Error:', error);
        // Handle the error, maybe notify the user.
      });

    return await modal.present();
  }

  private processReturnedData(data: any, view: ViewType) {
    const names = [];
    const ids = [];
    for (const item of data) {
      if (view === "groups") {
        names.push(item.group_name);
      } else if (view === "categories") {
        names.push(item.category_name);
      }
      ids.push(item.id);
    }
    if (view === "groups") {
      this.searchCriteriaForm.patchValue({
        groups: names.join(', '),
        groupIDs: ids
      });
    } else if (view === "categories") {
      this.searchCriteriaForm.patchValue({
        categories: names.join(', '),
        categoryIDs: ids
      });
    }
  }

  selectChange(changeType: string, event: any) {
    if (changeType === 'status') {
      let id = null;

      if (event.detail.value === 'Active') {
        id = StatusID.ACTIVE;
      } else if (event.detail.value === 'Inactive') {
        id = StatusID.INACTIVE;
      }

      this.searchCriteriaForm.patchValue({
        statusID: id
      });
    } else if (changeType === 'sex') {
      let id = null;
      if (event.detail.value === 'Bull') {
        id = SexID.BULL;
      } else if (event.detail.value === 'Steer') {
        id = SexID.STEER;
      } else if (event.detail.value === 'Cow') {
        id = SexID.COW;
      } else if (event.detail.value === 'Unknown') {
        id = SexID.UNKNOWN;
      }

      this.searchCriteriaForm.patchValue({
        sexID: id
      });
    }
  }

  applySearchCriteria() {
    let criteria = {};

    if (this.itemType === 'animals') {
      criteria = {
        status: this.searchCriteriaForm.get('status')?.value,
        statusID: this.searchCriteriaForm.get('statusID')?.value,
        primaryID: this.searchCriteriaForm.get('primaryID')?.value,
        sex: this.searchCriteriaForm.get('sex')?.value,
        sexID: +this.searchCriteriaForm.get('sexID')?.value,
        birthStartDate: this.searchCriteriaForm.get('birthStartDate')?.value,
        birthEndDate: this.searchCriteriaForm.get('birthEndDate')?.value,
        purchaseStartDate: this.searchCriteriaForm.get('purchaseStartDate')?.value,
        purchaseEndDate: this.searchCriteriaForm.get('purchaseEndDate')?.value,
        groups: this.searchCriteriaForm.get('groups')?.value,
        groupIDs: this.searchCriteriaForm.get('groupIDs')?.value,
        categories: this.searchCriteriaForm.get('categories')?.value,
        categoryIDs: this.searchCriteriaForm.get('categoryIDs')?.value,
      };
    } else if (this.itemType === 'groups') {
      criteria = {
        groupName: this.searchCriteriaForm.get('groupName')?.value,
        amountAnimals: this.searchCriteriaForm.get('amountAnimals')?.value,
        categories: this.searchCriteriaForm.get('categories')?.value,
        categoryIDs: this.searchCriteriaForm.get('categoryIDs')?.value,
      };
    }

    console.log(criteria);

    if (criteria) {
      console.log(`criteria: ${criteria}`)
      this.modalCtrl.dismiss(criteria);
    } else {
      this.modalCtrl.dismiss();
    }
  }

  dismiss() {
    this.modalCtrl.dismiss();
  }

  ngOnInit() {
    console.log(`Search Criteria passed itemType: ${this.itemType}`);
    console.log(`Search Criteria coming from page: ${this.page}`);
  }

}
