import { Component, OnInit } from '@angular/core';
import { DataService } from 'src/app/services/data.service';
import { AddService } from 'src/app/services/add.service';
import { ModalController } from '@ionic/angular';

@Component({
  selector: 'app-search-groups-categories',
  templateUrl: './search-groups-categories.page.html',
  styleUrls: ['./search-groups-categories.page.scss'],
})
export class SearchGroupsCategoriesPage implements OnInit {
  public selectedLength = 0;
  public selectAllFlag = 'unchecked';
  public filteredCategories: any = [];
  public categories: any = [];
  public viewType = '';
  public groups: any = [];
  public selected: any = [];
  public filteredGroups: any = [];

  constructor(
    private dataService: DataService,
    private addService: AddService,
    private modalCtrl: ModalController
  ) { }

  // Dismiss `Search Groups Categories` modal with selected item
  done() {
    console.log(this.selected);
    this.modalCtrl.dismiss(this.selected);
  }

  // Dismiss `Search Groups Categories` modal
  dismiss() {
    this.modalCtrl.dismiss();
  }

  searchBar(event: any) {
    if (this.viewType === 'groups') {
      this.filteredGroups = this.groups.filter((group: any) =>
        group.group_name.toLowerCase().indexOf(event.detail.value.toLowerCase()) > -1);
    } else if (this.viewType === 'categories') {
      this.filteredCategories = this.categories.filter((cat: any) =>
        cat.category_name.toLowerCase().indexOf(event.detail.value.toLowerCase()) > -1);
    }

    return this.filteredCategories;
  }

  // Select all current list items
  selectAll(event: any) {

    let items: any;

    // set list of items depending on if we are viewing a list of animals or groups
    if (this.viewType === 'groups') {
      items = this.filteredGroups;
    } else if (this.viewType === 'categories') {
      items = this.filteredCategories;
    }

    /*
    * True/false for event checked is backwards???
    * False means it is checked, true means it is unchecked
    * If, Select All is checked/tapped (false); set current as true; append to list
    * Else, Select All is unchecked (true); unchecked all and clear list
    */
    if (!event.target.checked) {
      this.selectAllFlag = 'checked';

      // iterate through items and set all to checked
      // push to list of selected items if they are not already in the list
      for (const i of items) {
        i.isChecked = true;
        if (!this.selected.includes(i)) {
          this.selected.push(i);
        }
      }

    } else if (event.target.checked) {
      // else if the user taps "Deselect All", all value are removed from list
      this.selectAllFlag = 'unchecked';

      // uncheck/deselect all items
      for (const i of items) {
        i.isChecked = false;
      }

      // set list of selected items to empty
      this.selected = [];
    }

    // update current length of selected (used to enable/disable 'Continue' button)
    this.selectedLength = this.selected.length;
  }

  // // detect when a checkbox for a group has been selected/deselected; adjust our selected list as needed
  // checkboxChanged(selection: any) {
  //   console.log(selection);
  //   console.log(this.selected);
  //   if (this.selected.includes(selection)) {
  //     /*
  //     * If we have items in our selected list and the current selected item already exists in the list,
  //         then the user is "uncheck"/"deselect"-ing the value, so we remove it from out list
  //     */
  //     const index = this.selected.indexOf(selection);
  //     this.selected.splice(index, 1);
  //   } else {
  //     /* Else, there are no items in our selected list or the current selected item is not in the list
  //         push the selection to our list of selected items
  //     */
  //     this.selected.push(selection);
  //   }

  //   // update current length of selected (used to enable/disable 'Continue' button)
  //   this.selectedLength = this.selected.length;
  // }

    // Detect when a checkbox for a group has been selected/deselected; adjust our selected list as needed
    checkboxChanged(selection: any) {
      console.log(selection);
      const index = this.selected.findIndex((item: { id: any; }) => item.id === selection.id);
  
      if (index !== -1) {
        // Item found, remove it from the array
        this.selected.splice(index, 1);
      } else {
        // Item not found, add it to the array
        this.selected.push(selection);
      }
  
      // Update current length of selected (used to enable/disable 'Continue' button)
      this.selectedLength = this.selected.length;
    }

  ionViewDidEnter() {
    if (this.viewType === 'groups') {
      this.dataService.get('getGroups', null)
        .then((data: any) => {
          if (data && data.length > 0) {
            this.dataService.presentLoading();
            this.groups = data;
            this.filteredGroups = this.groups;
          }
        })
        .catch((error: any) => {
          console.log(`Search Groups Get Groups Error: ${error}`);
          this.addService.displayAlert('Search Groups Get Groups Error',
            'An error occurred while retrieving data. Please check network connection and try again.');
        });
    } else if (this.viewType === 'categories') {
      this.dataService.get('getGroupCategories', null)
        .then((data: any) => {
          if (data && data.length > 0) {
            this.dataService.presentLoading();
            this.categories = data;
            this.filteredCategories = this.categories;

          }
        })
        .catch((error: any) => {
          console.log(`Search Groups Get Group Categories Error: ${error}`);
          this.addService.displayAlert('Search Groups Get Group Categories Error',
            'An error occurred while retrieving data. Please check network connection and try again.');
        });
    }
  }

  ngOnInit() {
    console.log('Search Groups/Categories view type:', this.viewType);
  }

}
