import { Component, OnInit } from '@angular/core';
import { Router, NavigationExtras } from '@angular/router';
import { ModalController } from '@ionic/angular';
import { CategoriesPage } from '../categories/categories.page';

@Component({
  selector: 'app-settings',
  templateUrl: './settings.page.html',
  styleUrls: ['./settings.page.scss'],
})
export class SettingsPage implements OnInit {

  constructor(
    private modalCtrl: ModalController,
    private router: Router
  ) { }

  /*
  * Present page view that shows the user's groups in a list
      the user can view/edit an individual group by tapping on the group in the list
  */
  editGroupInformation() {
    const navigationExtras: NavigationExtras = {
      state: {
        viewType: 'settings',
        itemType: null,
        passedSelected: null
      }
    };

    // Navigate to the add page for multiple animals and pass the current group ID
    this.router.navigateByUrl('/tabs/settings/manage', navigationExtras);
  }

  // Present modal that shows the user's group categories in a list they can view/edit
  async editGroupCategories() {
    const modal = await this.modalCtrl.create({
      component: CategoriesPage,
      componentProps: {
        viewType: 'settings'
      }
    });

    return await modal.present();
  }

  ngOnInit() { }

}
