import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { TabsPage } from './tabs.page';

const routes: Routes = [
  {
    path: '',
    component: TabsPage,
    children: [
      {
        path: 'home',
        children: [
          {
            path: '',
            loadChildren: () =>
              import('../home/home.module').then(m => m.HomePageModule)
          },
          {
            path: 'manage',
            children: [
              {
                path: '',
                loadChildren: () =>
                  import('../manage/manage.module').then(m => m.ManagePageModule)
              },
              {
                path: 'add-group/:type/:amount',
                loadChildren: () =>
                  import('../add-group/add-group.module').then(m => m.AddGroupPageModule)
              },
              {
                path: 'group-animals/:groupID/:groupName/:view',
                loadChildren: () =>
                  import('../group-animals/group-animals.module').then(m => m.GroupAnimalsPageModule)
              },
              {
                path: 'add-animal/:type/:amount',
                loadChildren: () =>
                  import('../add-animal/add-animal.module').then(m => m.AddAnimalPageModule)
              },
              {
                path: 'add-existing',
                loadChildren: () =>
                  import('../add-existing/add-existing.module').then(m => m.AddExistingPageModule)
              },
              {
                path: 'edit-animal/group/:groupID/:groupName/animal/:animalID',
                loadChildren: () =>
                  import('../edit-animal/edit-animal.module').then(m => m.EditAnimalPageModule)
              }
            ]
          },
          {
            path: 'actions',
            children: [
              {
                /*
                * As of March 2021
                * The original Actions page was removed (and renamed to Record Data)
                * If the user taps Record Data from the Home screen, they will be automatically
                    be sent to the "Actions Filter" page which lists all of their animals.
                * From there, they can filter the results down based on a search criteria.
                * All instances of the Actions page should be removed, however, if there is still some
                    instance that redirects to the /tabs/home/actions page, navigate to Home
                */
                path: '',
                loadChildren: () =>
                  import('../home/home.module').then(m => m.HomePageModule)
              },
              {
                path: 'actions-filter/:filter/:id',
                loadChildren: () =>
                  import('../actions-filter/actions-filter.module').then(m => m.ActionsFilterPageModule)
              },
              {
                path: 'actions-select',
                loadChildren: () =>
                  import('../actions-select/actions-select.module').then(m => m.ActionsSelectPageModule)
              },
              {
                path: 'manage',
                loadChildren: () =>
                  import('../manage/manage.module').then(m => m.ManagePageModule)
              },
              {
                path: 'health',
                loadChildren: () =>
                  import('../health/health.module').then(m => m.HealthPageModule)
              },
              {
                path: 'vaccination',
                loadChildren: () =>
                  import('../vaccination/vaccination.module').then(m => m.VaccinationPageModule)
              },
              {
                path: 'custom-form',
                loadChildren: () =>
                  import('../custom-form/custom-form.module').then(m => m.CustomFormPageModule)
              },
              {
                path: 'breeding',
                loadChildren: () => import('../breeding/breeding.module').then(m => m.BreedingPageModule)
              }
            ]
          }
        ]
      },
      {
        path: 'manage-animals',
        children: [
          {
            path: '',
            loadChildren: () =>
              import('../manage-animals/manage-animals.module').then(m => m.ManageAnimalsPageModule)
          },
          {
            path: 'edit-animal/group/:groupID/:groupName/animal/:animalID',
            loadChildren: () =>
              import('../edit-animal/edit-animal.module').then(m => m.EditAnimalPageModule)
          }
        ]
      },
      {
        path: 'reports',
        children: [
          {
            path: '',
            loadChildren: () =>
              import('../reports/reports.module').then(m => m.ReportsPageModule)
          },
          {
            path: 'reports-criteria/:report',
            loadChildren: () => import('../reports-criteria/reports-criteria.module').then(m => m.ReportsCriteriaPageModule)
          }
        ]
      },
      {
        path: 'settings',
        children: [
          {
            path: '',
            loadChildren: () =>
              import('../settings/settings.module').then(m => m.SettingsPageModule)
          },
          {
            path: 'manage',
            children: [
              {
                path: '',
                loadChildren: () =>
                  import('../manage/manage.module').then(m => m.ManagePageModule)
              },
              {
                path: 'edit-group',
                loadChildren: () =>
                  import('../edit-group/edit-group.module').then(m => m.EditGroupPageModule)
              }
            ]
          }
        ]
      },
      {
        path: '',
        redirectTo: '/tabs/home',
        pathMatch: 'full'
      }
    ]
  },
  {
    path: '',
    redirectTo: '/tabs/home',
    pathMatch: 'full'
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class TabsPageRoutingModule { }
