import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { AccountService } from './account.service';
import { AlertController } from '@ionic/angular';
import { Toast } from '@capacitor/toast';

@Injectable({
  providedIn: 'root'
})
export class ActionsService {

  private apiURL = 'https://calfstewardship.extension.msstate.edu/app/';

  constructor(
    private accountService: AccountService,
    private httpClient: HttpClient,
    private alertCtrl: AlertController
  ) { }

  // Display toast message to user that their action was successful
  async actionToast(actionType: string, itemType: string) {
    if (actionType && itemType) {
      let messageText = '';

      // Capitalize the passed action type
      const capitalizeActionType = actionType[0].toUpperCase() + actionType.slice(1);

      // Determine if we are dealing with animals or groups to set appropriate message string
      if (itemType === 'animals') {
        messageText = `Animal(s) ${capitalizeActionType} Event was successful.`;
      } else if (itemType === 'groups') {
        messageText = `Group(s) ${capitalizeActionType} Event was successful.`;
      }

      if (messageText) {
        await Toast.show({
          text: messageText,
          duration: 'short',
          position: 'top'
        });
      }
    }
  }

  async actionError(title: string) {
    const alert = await this.alertCtrl.create({
      header: title,
      message: 'An error occurred while performing action. Please check network connection and try again.',
      buttons: ['OK'],
      backdropDismiss: false
    });
    await alert.present();
  }

  // Move a list of animals or groups to a new group (associate new group id)
  async moveGroup(myItem: string, oldIDs: any, newID: number, myItemIDs: any) {
    if (oldIDs.length === myItemIDs.length) {

      // Initialize amount (string) that is being handled ('multiple' or 'single')
      let myAmount = '';

      if (myItemIDs.length > 1) {
        myAmount = 'multiple';
      } else if (myItemIDs.length === 1) {
        myAmount = 'single';
      }

      // Check to see that the user has logged in
      const userID = await this.accountService.checkLogin('data');

      // If the user is logged in (`userID` set)
      if (userID) {

        // Set data to be passed for moving items to new group
        const data = {
          action: 1,
          item: myItem,
          amount: myAmount,
          oldIDs,
          newID,
          itemIDs: myItemIDs,
          userID,
          loggedIn: true
        };

        console.log(`actionsService moveGroup data: ${JSON.stringify(data)}`);

        return new Promise((resolve, reject) => {
          this.httpClient.post(`${this.apiURL}/actionsMoveGroup.php`, data)
            .subscribe(response => {
              console.log(`actionsService moveGroup response: ${response}`);
              if (response && response === 'success') {
                resolve(response);
              } else {
                reject(null);
              }
            });
        });
      }
    }
  }
}
