<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       actionsBreedingEvent.php
DESCRIPTION:
*/

// define local time zone and format
date_default_timezone_set('America/Chicago');

function breedingEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $breedingData)
{
    if ($itemType == 'animals') {
        $insertBreedingEventQuery = $mysqli->prepare('INSERT INTO `event_breeding`
        (`action_type_id`, `action_id`, `animal_id`, `bull_id`, `date`, `event_type_id`,
        `technician`, `notes`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?)');
    } elseif ($itemType === 'groups') {
        $insertBreedingEventQuery = $mysqli->prepare('INSERT INTO `event_breeding`
        (`action_type_id`, `action_id`, `group_id`, `bull_id`, `date`, `event_type_id`,
        `technician`, `notes`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?)');
    } else {
        echo json_encode('Invalid Breeding (Natural Service) Item Type!');
        exit(1);
    }

    // set date created/updated for record insertion
    $eventDateTime = date('Y-m-d H:i:s');

    if (
        $insertBreedingEventQuery &&
        $insertBreedingEventQuery->bind_param(
            'iiiisissss',
            $actionTypeID, // action type ID
            $actionID, // action ID
            $id, // ID of item (animal or group)
            $breedingData[1], // bull ID (required from selecting bull)
            $breedingData[3], // date (required)
            $breedingData[2], // event type ID (required)
            $breedingData[4], // technician (optional)
            $breedingData[5], // notes (optional)
            $userID, // user ID
            $eventDateTime // database record date
        ) &&
        $insertBreedingEventQuery->execute()
    ) {
        $insertBreedingEventQuery->close();
        return;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}


function getBreedingActionID($mysqli, $actionTypeID, $action, $itemType, $selectedAmount)
{
    // Determine the ID associated with the current action based on the action type ID, action, item, and amount
    $selectActionIDQuery = $mysqli->prepare(
        'SELECT `id`
        FROM `actions`
        WHERE `action_type_id` = ?
        AND `action` = ?
        AND `item` = ?
        AND `amount` = ?'
    );

    $actionID = NULL;

    if (
        $selectActionIDQuery &&
        $selectActionIDQuery->bind_param(
            'isss',
            $actionTypeID,
            $action,
            $itemType,
            $selectedAmount
        ) &&
        $selectActionIDQuery->execute()
    ) {
        $selectActionIDQuery->store_result();
        $selectActionIDQuery->bind_result($actionID);
        $selectActionIDQuery->fetch();
        return $actionID;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}


// make sure we have received a post request from app
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = file_get_contents('php://input');

    $request = json_decode($data);

    if ($request && $request[0] && $request[1]) {
        require('connection.php');
        // 5 for `breeding`
        $actionTypeID = intval($mysqli->real_escape_string($request[0]->actionTypeID));
        // `breeding`
        $action = $mysqli->real_escape_string($request[0]->action);
        // `animals` or `groups`
        $itemType = $mysqli->real_escape_string($request[0]->itemType);
        $selectedAmount = $mysqli->real_escape_string($request[0]->selectedAmount);
        $cowIDs = $request[0]->cowIDs;
        $userID = $mysqli->real_escape_string($request[0]->userID);
        $loggedIn = $request[0]->loggedIn;

        /*
        BREEDING FORM
        bull: $breedingData[0]
        bullID: $breedingData[1]
        eventType: $breedingData[2]
        date: $breedingData[3]
        technician: $breedingDate[4]
        notes: $breedingDate[5]
        */

        if ($userID && $loggedIn) {
            // $request[1] = formData object
            if ($request[1]) {
                $breedingData = array();

                foreach ($request[1] as $key => $value) {
                    // If value is empty or string "null", append null to array.
                    if (empty($value) || $value === 'null') {
                        $breedingData[] = null;
                    } else {
                        // Otherwise, append cleaned value
                        $trimmedValue = trim($value);
                        $escapedValue = $mysqli->real_escape_string($trimmedValue);
                        $breedingData[] = $escapedValue;
                    }
                }
            } else {
                echo json_encode('No Breeding form data!');
                exit(1);
            }

            // If there is breeding data (extracted from passed form data object)
            if ($breedingData) {

                $actionID = getBreedingActionID($mysqli, $actionTypeID, $action, $itemType, $selectedAmount);

                if ($actionID) {
                    foreach ($cowIDs as $id) {
                        breedingEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $breedingData);
                    }
                } else {
                    echo json_encode('No Breeding Action ID!');
                    exit(1);
                }
            } else {
                echo json_encode('No Breeding data!');
                exit(1);
            }
        } else {
            echo json_encode('Not logged in!');
            exit(1);
        }

        echo json_encode('success');
        $mysqli->close();
    } else {
        echo json_encode('No data!');
        exit(1);
    }
} else {
    echo json_encode('Invalid Breeding Event!');
    exit(1);
}
