<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       actionsPerformanceProductionEvent.php
DESCRIPTION:
*/

// define local time zone and format
date_default_timezone_set('America/Chicago');

function vaccinationEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $vaccinationData)
{
    if ($itemType == 'animals') {
        $insertVaccinationEventQuery = $mysqli->prepare('INSERT INTO `event_vaccination`
        (`action_type_id`, `action_id`, `animal_id`, `date`, `volume`, `units`, `vaccine`, `vaccine_other`,
        `route_administration`, `serial_number`, `expiration_date`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)');
    } elseif ($itemType === 'groups') {
        $insertVaccinationEventQuery = $mysqli->prepare('INSERT INTO `event_vaccination`
        (`action_type_id`, `action_id`, `group_id`, `date`, `volume`, `units`, `vaccine`, `vaccine_other`,
        `route_administration`, `serial_number`, `expiration_date`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)');
    } else {
        echo json_encode('Invalid Vaccination Item Type!');
        exit(1);
    }

    // set date created/updated for record insertion
    $eventDateTime = date('Y-m-d H:i:s');

    if (
        $insertVaccinationEventQuery &&
        $insertVaccinationEventQuery->bind_param(
            'iiisissssssss',
            $actionTypeID, // action type ID
            $actionID, // action ID
            $id, // ID of item (animal or group)
            $vaccinationData[0], // date
            $vaccinationData[1], // volume (optional)
            $vaccinationData[2], // units
            $vaccinationData[3], // vaccine
            $vaccinationData[4], // vaccine other (if the user select "Other" as vaccine and inputs another vaccine)
            $vaccinationData[5], // route of adminstration
            $vaccinationData[6], // serial number (optional)
            $vaccinationData[7], // expiration date (optional)
            $userID,
            $eventDateTime
        ) &&
        $insertVaccinationEventQuery->execute()
    ) {
        $insertVaccinationEventQuery->close();
        return;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}

function treatmentHealthEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $healthData)
{
    if ($itemType == 'animals') {
        $insertHealthEventQuery = $mysqli->prepare('INSERT INTO `event_health`
        (`action_type_id`, `action_id`, `animal_id`, `date`, `volume`, `units`, `product`, `product_other`,
        `route_administration`, `reason`, `problem_bs`, `problem_bsc`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
    } elseif ($itemType === 'groups') {
        $insertHealthEventQuery = $mysqli->prepare('INSERT INTO `event_health`
        (`action_type_id`, `action_id`, `group_id`, `date`, `volume`, `units`, `product`, `product_other`,
        `route_administration`, `reason`, `problem_bs`, `problem_bsc`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
    } else {
        echo json_encode('Invalid Health (Treatment) Item Type!');
        exit(1);
    }

    // set date created/updated for record insertion
    $eventDateTime = date('Y-m-d H:i:s');

    if (
        $insertHealthEventQuery &&
        $insertHealthEventQuery->bind_param(
            'iiisisssiiiiss',
            $actionTypeID, // action type ID
            $actionID, // action ID
            $id, // ID of item (animal or group)
            $healthData[0], // date
            $healthData[1], // volume (optional)
            $healthData[2], // units
            $healthData[3], // product
            $healthData[4], // product other (if the user select "Other" as product and inputs another product)
            $healthData[5], // route of administration
            $healthData[6], // reason
            $healthData[7], // problem body system
            $healthData[8], // problem body system condition
            $userID, // user ID
            $eventDateTime // database record date
        ) &&
        $insertHealthEventQuery->execute()
    ) {
        $insertHealthEventQuery->close();
        return;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}

function productionEvent($mysqli, $id, $actionTypeID,  $actionID, $itemType, $userID, $productionData)
{
    if ($itemType === 'animals') {
        $insertProductionEventQuery = $mysqli->prepare('INSERT INTO `event_production`
        (`action_type_id`, `action_id`, `animal_id`, `weaning_weight`, `yearling_weight`, `mature_weight`, `hip_height`, `bcs`, `repro_tract_score`,
        `chute_docility_score`, `foot_angle_score`, `claw_set_score`, `teat_score`, `udder_score`, `bse_motility`, `bse_morphology`, `bse_acceptable`,
        `pregnancy_status`, `gestation_length`, `gl_units`, `castration_tech`, `castration_date`, `dehorning_tech`, `dehorning_date`, `spaying_tech`,
        `spaying_date`, `body_temperature`, `comments`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
    } elseif ($itemType === 'groups') {
        $insertProductionEventQuery = $mysqli->prepare('INSERT INTO `event_production`
        (`action_type_id`, `action_id`, `group_id`, `weaning_weight`, `yearling_weight`, `mature_weight`, `hip_height`, `bcs`, `repro_tract_score`,
        `chute_docility_score`, `foot_angle_score`, `claw_set_score`, `teat_score`, `udder_score`, `bse_motility`, `bse_morphology`, `bse_acceptable`,
        `pregnancy_status`, `gestation_length`, `gl_units`, `castration_tech`, `castration_date`, `dehorning_tech`, `dehorning_date`, `spaying_tech`,
        `spaying_date`, `body_temperature`, `comments`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
    } else {
        echo json_encode('Invalid Production Item Type!');
        exit(1);
    }

    // set date created/updated for record insertion
    $eventDateTime = date('Y-m-d H:i:s');

    if (
        $insertProductionEventQuery &&
        $insertProductionEventQuery->bind_param(
            'iiiiiiiiiiiiiiiiisdsisisisssss',
            $actionTypeID, // action type ID
            $actionID, // action ID
            $id, // ID of item (animal or group)
            $productionData[0], // weaning weight
            $productionData[1], // yearling weight
            $productionData[2], // mature weight
            $productionData[3], // hip height
            $productionData[4], // body condition score (bcs)
            $productionData[5], // reproductive tract score (cows only)
            $productionData[6], // chute docility score
            $productionData[7], // foot angle score
            $productionData[8], // claw set score
            $productionData[9], // teat score (cows only)
            $productionData[10], // udder score (cows only)
            $productionData[11], // bse motility (breeding soundness exam) (bulls only)
            $productionData[12], // bse morphology (breeding soundness exam) (bulls only)
            $productionData[13], // bse acceptable (breeding soundness exam) (bulls only)
            $productionData[14], // pregnancy status (cows only)
            $productionData[15], // pregnancy gestation length (cows only)
            $productionData[16], // pregnancy gestation length units (cows only)
            $productionData[17], // castration technique (bulls only)
            $productionData[18], // castration date (bulls only)
            $productionData[19], // dehorning technique (all)
            $productionData[20], // dehorning date (all)
            $productionData[21], // spaying technique (cows only)
            $productionData[22], // spaying date (cows only)
            $productionData[23], // body temperature
            $productionData[24], // comments
            $userID, // user ID
            $eventDateTime // database record date
        ) &&
        $insertProductionEventQuery->execute()
    ) {
        $insertProductionEventQuery->close();
        return;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}

function getPerformanceActionID($mysqli, $actionTypeID, $action, $itemType, $selectedAmount)
{
    // Determine the ID associated with the current action based on the action type ID, action, item, and amount
    $selectActionIDQuery = $mysqli->prepare(
        'SELECT `id`
        FROM `actions`
        WHERE `action_type_id` = ?
        AND `action` = ?
        AND `item` = ?
        AND `amount` = ?'
    );

    $actionID = NULL;

    if (
        $selectActionIDQuery &&
        $selectActionIDQuery->bind_param(
            'isss',
            $actionTypeID,
            $action,
            $itemType,
            $selectedAmount
        ) &&
        $selectActionIDQuery->execute()
    ) {
        $selectActionIDQuery->store_result();
        $selectActionIDQuery->bind_result($actionID);
        $selectActionIDQuery->fetch();
        return $actionID;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}


// make sure we have received a post request from app
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = file_get_contents('php://input');

    $request = json_decode($data);

    if ($request && $request[0] && $request[1]) {
        require('connection.php');
        // 5 for `performanceProduction`
        $actionTypeID = intval($mysqli->real_escape_string($request[0]->actionTypeID));
        // e.g., `production` or `pregnancy`
        $action = $mysqli->real_escape_string($request[0]->action);
        // e.g., `animals` or `groups`
        $itemType = $mysqli->real_escape_string($request[0]->itemType);
        // e.g., `single` or `multiple`
        $selectedAmount = $mysqli->real_escape_string($request[0]->selectedAmount);
        $IDs = $request[0]->IDs;
        $userID = $mysqli->real_escape_string($request[0]->userID);
        $loggedIn = $request[0]->loggedIn;

        /*
        custom form
        weaningWeight: $formData[0]
        yearlingWeight: $formData[1]
        matureWeight: $formData[2]
        hipHeight: $formData[3]
        bodyConditionScore: $formData[4]
        // reproductive tract score (cows only)
        reproductiveTractScore: $formData[5]
        chuteDocilityScore: $formData[6]
        footAngleScore: $formData[7]
        clawSetScore: $formData[8]
        // teat and udder (cows only)
        teatScore: $formData[9]
        udderScore: $formData[10]
        // bse = breeding soundness exam (bulls only)
        bseMotility: $formData[11]
        bseMorphology: $formData[12]
        bseAcceptableBreeder: $formData[13]
        // pregnancy diagnosis (cows only)
        pregnancyStatus: $formData[14]
        gestationLength: $formData[15]
        gestationLengthUnits: $formData[16]
        // castration (bulls only)
        castrationTechnique: $formData[17]
        castrationDate: $formData[18]
        // dehorning (all)
        dehorningTechnique: $formData[19]
        dehorningDate: $formData[20]
        // spaying (cows only)
        spayingTechnique: $formData[21]
        spayingDate: $formData[22]
        // comment box provided for each form automatically
        comments: $formData[23]
        */

        if ($userID && $loggedIn) {
            // $request[1] = formDataList, list of form dictionaries
            if ($request[1]) {

                // Initialize array to hold form data arrays (array of arrays)
                $allFormData = array();

                // Iterate through each of the passed form dictionaries from the list
                foreach ($request[1] as $r) {
                    // Initialize array to hold current form data
                    $formData = array();

                    // Iterate through the current form data as key/value pairs
                    foreach ($r as $key => $value) {
                        /*
                        * The "ID" key was added to the form data to keep track of item's input data 
                            when the user would navigate between them using the added "Tap to Select" button.
                            That way, if the user came across a selected item again, the data would load.
                        */
                        if ($key == 'id') {
                            continue;
                        } elseif (empty($value) || $value === 'null') {
                            /*
                            * Check to see if value is empty or string "null"
                            * If so, append null to array
                            */
                            $formData[] = null;
                        } else {
                            /*
                            * Otherwise, append the value after escaping string
                            * Escape special characters in a string for use in an SQL statement,
                                taking into account the current charset of the connection
                            */
                            $formData[] = $mysqli->real_escape_string($value);
                        }
                    }

                    // Push the current data array into the list of all data
                    $allFormData[] = $formData;
                }
            } else {
                echo json_encode('No form data!');
                exit(1);
            }

            /*
            * If there is data (extracted from passed form data list of form dictionaries)
                and the length of items from the list of form dictionaries equals to length of the list of arrays
            */
            if ($allFormData && count($request[1]) == count($allFormData)) {

                $actionID = getPerformanceActionID($mysqli, $actionTypeID, $action, $itemType, $selectedAmount);

                if ($actionID) {
                    foreach ($IDs as $key => $id) {
                        if ($action === 'production') {
                            productionEvent($mysqli, $id, $actionTypeID,  $actionID, $itemType, $userID, $allFormData[$key]);
                        } else {
                            echo json_encode('No Performance/Production Action!');
                            exit(1);
                        }
                    }
                } else {
                    echo json_encode('No Performance/Production Action ID!');
                    exit(1);
                }
            } else {
                echo json_encode('No Performance/Production data!');
                exit(1);
            }

            /*
            * $request[2] = additionalOptionsIDs, list of lists containing IDs for 
                selected items which have an additional option (treatment or vaccination applied)
            * $request[3] = filteredAdditional (options), help identify which option corresponds to which set of IDs
            * $request[4] = actionsData, this corresponds to a list of objects representing selected Treatments or Vaccinations applied to selected items
            * Check to see that $request[2], $request[3] and $request[4] all have data before proceeding
            */
            if ($request[2] && $request[3] && ($request[4])) {

                // Iterate through the additional options IDs list of lists, which holds the item IDs for which to apply a Treatment or Vaccination
                foreach ($request[2] as $key => $value) {
                    $currentIDs = $value;

                    // If there is a current list of IDs and a defined item type ("animals" or "groups") then proceed
                    if ($currentIDs && $itemType) {
                        // If the current filtered additional option value contains "Treatment", then process the animals as a Health Event
                        if (strpos($request[3][$key]->value, 'Treatment') !== false && $request[4][$key]) {

                            // Define an array to hold the object values for the current Health data object
                            $currentHealthData = array();

                            /*
                            * Iterate through the current Health data object and push the values into an array
                            * This array will be used to process the IDs associated with the Heath data (Treatment) at the specific index
                            */
                            foreach ($request[4][$key] as $k => $v) {

                                /*
                                * The `volume` input field was made optional since defining an additional option within the custom form applies to all selected items
                                * So, if the user selected a volume amount then that would apply to all items, which is not the case
                                * Set empty `volume` value to NULL
                                */
                                if ($v === '') {
                                    $v = NULL;
                                }

                                $currentHealthData[] = $v;
                            }

                            // Set appropriate variables related to action
                            $actionTypeID = 2; // 2 = health

                            if ($itemType === 'animals') {
                                $actionID = 9; // 9 = health (treatment) for single animal
                            } else if ($itemType === 'groups') {
                                $actionID = 11; // 11 = health (treatment) for single group
                            }

                            // Iterate through the IDs and process Health (Treatment) events
                            foreach ($currentIDs as $id) {
                                treatmentHealthEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $currentHealthData);
                            }
                        } else if (strpos($request[3][$key]->value, 'Vaccination') !== false && $request[4][$key]) {
                            // Else, if the current filtered additional option value contains "Vaccination", then process the animals as a Vaccination Event

                            // Define an array to hold the object values for the current Vaccination data object
                            $currentVaccinationData = array();

                            /*
                            * Iterate through the current Vaccination data object and push the values into an array
                            * This array will be used to process the IDs associated with the Vaccination data at the specific index
                            */
                            foreach ($request[4][$key] as $k => $v) {

                                /*
                                * The `volume` input field was made optional since defining an additional option within the custom form applies to all selected items
                                * So, if the user selected a volume amount then that would apply to all items, which is not the case
                                * Set empty `volume` value to NULL
                                * Additionally, the `serial number` and `expiration date` fields were originally optional, convert their empty values to NULL
                                */
                                if ($v === '') {
                                    $v = NULL;
                                }

                                $currentVaccinationData[] = $v;
                            }

                            // Set appropriate variables related to action
                            $actionTypeID = 3; // 3 = vaccination

                            if ($itemType === 'animals') {
                                $actionID = 13; // 13 = vaccination for single animal
                            } else if ($itemType === 'groups') {
                                $actionID = 15; // 14 = vaccination for single group
                            }

                            // Iterate through the IDs and process Vaccination events
                            foreach ($currentIDs as $id) {
                                vaccinationEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $currentVaccinationData);
                            }
                        }
                    }
                }
            }
        } else {
            echo json_encode('Not logged in!');
            exit(1);
        }

        echo json_encode('success');
        $mysqli->close();
    } else {
        echo json_encode('No data!');
        exit(1);
    }
} else {
    echo json_encode('Invalid Performance/Production Event!');
    exit(1);
}
