<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       actionsProcessingEvent.php
DESCRIPTION:
*/

// define local time zone and format
date_default_timezone_set('America/Chicago');

function processingEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $processingData)
{
    if ($itemType == 'animals') {
        $insertProcessingEventQuery = $mysqli->prepare('INSERT INTO `event_processing`
        (`action_type_id`, `action_id`, `animal_id`, `technique_id`, `date`, `comments`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?)');
    } elseif ($itemType === 'groups') {
        $insertProcessingEventQuery = $mysqli->prepare('INSERT INTO `event_processing`
        (`action_type_id`, `action_id`, `group_id`, `technique_id`, `date`, `comments`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?)');
    }

    // set date created/updated for record insertion
    $eventDateTime = date('Y-m-d H:i:s');

    if (
        $insertProcessingEventQuery &&
        $insertProcessingEventQuery->bind_param(
            'iiiissss',
            $actionTypeID, // action type ID
            $actionID, // action ID
            $id, // ID of item (animal or group)
            $processingData[0], // technique ID
            $processingData[1], // date (of event) (optional)
            $processingData[2], // comments (optional)
            $userID, // user ID
            $eventDateTime // database record date
        ) &&
        $insertProcessingEventQuery->execute()
    ) {
        $insertProcessingEventQuery->close();
        return;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}


function getActionID($mysqli, $actionTypeID, $action, $itemType, $selectedAmount)
{
    // Determine the ID associated with the current action based on the action type ID, action, item, and amount
    $selectActionIDQuery = $mysqli->prepare(
        'SELECT `id`
        FROM `actions`
        WHERE `action_type_id` = ?
        AND `action` = ?
        AND `item` = ?
        AND `amount` = ?'
    );

    $actionID = NULL;

    if (
        $selectActionIDQuery &&
        $selectActionIDQuery->bind_param(
            'isss',
            $actionTypeID,
            $action,
            $itemType,
            $selectedAmount
        ) &&
        $selectActionIDQuery->execute()
    ) {
        $selectActionIDQuery->store_result();
        $selectActionIDQuery->bind_result($actionID);
        $selectActionIDQuery->fetch();
        return $actionID;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}


// make sure we have received a post request from app
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = file_get_contents('php://input');

    $request = json_decode($data);

    if ($request && $request[0] && $request[1]) {
        require('connection.php');
        // 4 for `processing`
        $actionTypeID = intval($mysqli->real_escape_string($request[0]->actionTypeID));
        // e.g., `castration` or `dehorning` or `spaying`
        $action = $mysqli->real_escape_string($request[0]->action);
        // `animals` or `groups`
        $itemType = $mysqli->real_escape_string($request[0]->itemType);
        // `single` or `multiple`
        $selectedAmount = $mysqli->real_escape_string($request[0]->selectedAmount);
        $IDs = $request[0]->IDs;
        $userID = $mysqli->real_escape_string($request[0]->userID);
        $loggedIn = $request[0]->loggedIn;

        /*
        castration / dehorning / spaying form
        technique ID: $processingData[0]
        date: $processingData[1]
        comments: $processingData[2]
        */

        if ($userID && $loggedIn) {
            // $request[1] = formData object
            if ($request[1]) {
                $processingData = array();

                foreach ($request[1] as $key => $value) {
                    // check to see if value is empty; append null to array
                    if (empty($value) || $value === 'null') {
                        $processingData[] = null;
                    }
                    // otherwise, append the value after escaping string
                    // escape special characters in a string for use in an SQL statement, taking into account the current charset of the connection
                    else {
                        $processingData[] = $mysqli->real_escape_string($value);
                    }
                }
            } else {
                echo json_encode('No Processing form data!');
                exit(1);
            }

            // If there is processing data (extracted from passed form data object)
            if ($processingData) {

                // i.e., $actionID = 19 (castration), $actionID = 26 (dehorning), $actionID = 30 (spaying)
                $actionID = getActionID($mysqli, $actionTypeID, $action, $itemType, $selectedAmount);

                if ($actionID) {
                    foreach ($IDs as $id) {
                        processingEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $processingData);
                    }
                } else {
                    echo json_encode('No Processing Action ID!');
                    exit(1);
                }
            } else {
                echo json_encode('No Processing data!');
                exit(1);
            }
        } else {
            echo json_encode('Not logged in!');
            exit(1);
        }

        echo json_encode('success');
        $mysqli->close();
    } else {
        echo json_encode('No data!');
        exit(1);
    }
} else {
    echo json_encode('Invalid Processing Event!');
    exit(1);
}
