<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       actionsVaccinationEvent.php
DESCRIPTION:
*/

// define local time zone and format
date_default_timezone_set('America/Chicago');

function vaccinationEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $vaccinationData)
{
    if ($itemType == 'animals') {
        $insertVaccinationEventQuery = $mysqli->prepare('INSERT INTO `event_vaccination`
        (`action_type_id`, `action_id`, `animal_id`, `date`, `volume`, `units_id`, `vaccine`, `vaccine_other`,
        `roa_id`, `serial_number`, `expiration_date`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)');
    } elseif ($itemType === 'groups') {
        $insertVaccinationEventQuery = $mysqli->prepare('INSERT INTO `event_vaccination`
        (`action_type_id`, `action_id`, `group_id`, `date`, `volume`, `units_id`, `vaccine`, `vaccine_other`,
        `roa_id`, `serial_number`, `expiration_date`, `user_id`, `event_datetime`)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)');
    } else {
        echo json_encode('Invalid Vaccination Item Type!');
        exit(1);
    }

    // set date created/updated for record insertion
    $eventDateTime = date('Y-m-d H:i:s');

    if (
        $insertVaccinationEventQuery &&
        $insertVaccinationEventQuery->bind_param(
            'iiisdississss',
            $actionTypeID, // action type ID
            $actionID, // action ID
            $id, // ID of item (animal or group)
            $vaccinationData['date'], // date
            $vaccinationData['volume'], // volume (optional)
            $vaccinationData['units_id'], // units_id (references unit table)
            $vaccinationData['vaccine'], // vaccine
            $vaccinationData['vaccine_other'], // vaccine other (if the user select "Other" as vaccine and inputs another vaccine)
            $vaccinationData['roa_id'], // roa_id (references route of administration table)
            $vaccinationData['serial_number'], // serial number (sn) (optional)
            $vaccinationData['expiration_date'], // expiration date (eod) (optional)
            $userID,
            $eventDateTime
        ) &&
        $insertVaccinationEventQuery->execute()
    ) {
        $insertVaccinationEventQuery->close();
        return;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}


function getVaccinationActionID($mysqli, $actionTypeID, $action, $itemType, $selectedAmount)
{
    // Determine the ID associated with the current action based on the action type ID, action, item, and amount
    $selectActionIDQuery = $mysqli->prepare(
        'SELECT `id`
        FROM `actions`
        WHERE `action_type_id` = ?
        AND `action` = ?
        AND `item` = ?
        AND `amount` = ?'
    );

    $actionID = NULL;

    if (
        $selectActionIDQuery &&
        $selectActionIDQuery->bind_param(
            'isss',
            $actionTypeID,
            $action,
            $itemType,
            $selectedAmount
        ) &&
        $selectActionIDQuery->execute()
    ) {
        $selectActionIDQuery->store_result();
        $selectActionIDQuery->bind_result($actionID);
        $selectActionIDQuery->fetch();
        return $actionID;
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}

// make sure we have received a post request from app
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = file_get_contents('php://input');

    $request = json_decode($data, true);

    if ($request && $request[0] && $request[1]) {
        require('connection.php');
        // 3 for `vaccination`
        $actionTypeID = intval($mysqli->real_escape_string($request[0]['actionTypeID']));
        // e.g., `vaccination`
        $action = $mysqli->real_escape_string($request[0]['action']);
        // `animals` or `groups`
        $itemType = $mysqli->real_escape_string($request[0]['itemType']);
        $selectedAmount = $mysqli->real_escape_string($request[0]['selectedAmount']);
        $IDs = $request[0]['vaccineIDs'];
        $userID = $mysqli->real_escape_string($request[0]['userID']);
        $loggedIn = $request[0]['loggedIn'];

        if ($userID && $loggedIn) {
            // $request[1] = formData object
            if ($request[1]) {
                $vaccinationData = array();

                /*
                vaccination form:
                date: $vaccinationData['date'],
                volume: $vaccinationData['volume'],
                units_id: $vaccinationData['units_id'],
                vaccine: $vaccinationData['vaccine'],
                vaccine (other): $vaccinationData['vaccine_other'],
                route: $vaccinationData['roa_id'],
                serial number: $vaccinationData['serial_number'],
                expiration date: $vaccinationData['expiration_date']
                */

                foreach ($request[1] as $key => $value) {
                    // If value is empty or string "null", append null to array.
                    if (empty($value) || $value === 'null') {
                        $vaccinationData[$key] = null;
                    }
                    else {
                        // Otherwise, append cleaned value
                        $trimmedValue = trim($value);
                        $escapedValue = $mysqli->real_escape_string($trimmedValue);
                        $vaccinationData[$key] = $escapedValue;
                    }
                }
            } else {
                echo json_encode('No Vaccination form data!');
                exit(1);
            }

            // If there is vaccination data (extracted from passed form data object)
            if ($vaccinationData) {

                $actionID = getVaccinationActionID($mysqli, $actionTypeID, $action, $itemType, $selectedAmount);

                if ($actionID) {
                    foreach ($IDs as $id) {
                        vaccinationEvent($mysqli, $id, $actionTypeID, $actionID, $itemType, $userID, $vaccinationData);
                    }
                } else {
                    echo json_encode('No Vaccination Action ID!');
                    exit(1);
                }
            } else {
                echo json_encode('No Vaccination data!');
                exit(1);
            }
        } else {
            echo json_encode('Not logged in!');
            exit(1);
        }

        echo json_encode('success');
        $mysqli->close();
    } else {
        echo json_encode('No data!');
        exit(1);
    }
} else {
    echo json_encode('Invalid Vaccination Event!');
    exit(1);
}
