<?php
require('accessControl.php');

/*
BY:             krn
FILE:           addExistingAnimalsToGroup.php
DESCRIPTION:
*/

$message = 'Add Existing Animals To Group Error';

// make sure we have received a post request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $info = json_decode($data);

        // Check that object is set and not empty
        if (isset($info) && !empty($info)) {

            // Require database connection
            require('connection.php');

            // Define variables
            $userID = $info->userID;
            $loggedIn = $info->loggedIn;
            $groupID = $info->groupID;
            $animalIDs = $info->animalIDs;

            if ($userID && $loggedIn && $groupID && count($animalIDs) > 0) {
                // define local time zone and format
                date_default_timezone_set('America/Chicago');
                // set date created for record insertion
                $entryDate = date('Y-m-d H:i:s');

                foreach ($animalIDs as $animalID) {
                    $insertAnimalQuery = $mysqli->prepare('INSERT INTO `group_animals`
                                                        (`group_id`, `animal_id`, `user_id`, `entry_date`)
                                                        VALUES (?,?,?,?)');

                    if (
                        $insertAnimalQuery &&
                        $insertAnimalQuery->bind_param(
                            'iiss',
                            $groupID,
                            $animalID,
                            $userID,
                            $entryDate
                        ) &&
                        $insertAnimalQuery->execute()
                    ) {
                        $insertAnimalQuery->close();
                    } else {
                        $message = $mysqli->error;
                        break;
                    }
                }

                $message = 'success';
            } else {
                $message = 'No values!';
            }

            $mysqli->close();
        } else {
            $message = 'No info!';
        }
    } else {
        $message = 'No data!';
    }
}

echo json_encode($message);
