<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       addGroupCategory.php
DESCRIPTION:    Create a new database record for a group category in the `group_categories` table with the passed data.
*/

$message = 'Add Group Category Error';

// make sure we have received a post request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $info = json_decode($data);

        // Check that object is set and not empty
        if (isset($info) && !empty($info)) {

            // Require database connection
            require('connection.php');

            // Define variables
            $categoryName = $mysqli->real_escape_string($info->categoryName);
            $userID = $info->userID;
            $loggedIn = $info->loggedIn;

            // If variables have a value, continue with query
            if ($userID && $loggedIn && $categoryName) {
                // Define local time zone and format
                date_default_timezone_set('America/Chicago');

                // Set date created for record insertion
                $dateCreated = date('Y-m-d H:i:s');
                $dateUpdated = date('Y-m-d H:i:s');

                $insertGroupCategoryQuery = $mysqli->prepare('INSERT INTO `group_categories`
                                                            (`category_name`, `user_id`, `date_created`, `date_updated`)
                                                            VALUES (?,?,?,?)');

                if (
                    $insertGroupCategoryQuery &&
                    $insertGroupCategoryQuery->bind_param(
                        'ssss',
                        $categoryName,
                        $userID,
                        $dateCreated,
                        $dateUpdated
                    ) &&
                    $insertGroupCategoryQuery->execute()
                ) {
                    $insertGroupCategoryQuery->close();
                    $message = 'success';
                } else {
                    $message = $mysqli->error;
                }
            } else {
                $message = 'No values!';
            }

            $mysqli->close();
        } else {
            $message = 'No info!';
        }
    } else {
        $message = 'No data!';
    }
}

echo json_encode($message);
