<?php
require('accessControl.php');

/*
BY:             krn
FILE:           addGroups.php
DESCRIPTION:    Add new groups to database. Accepts form data submitted via a POST request,
                validating and sanitizing the input, and then inserting the new group into the database table `groups`.
                The script checks if the user is logged in and returns a response message based on the success or failure of the insertion process.
*/

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST) && !empty($_POST)) {
        // Connect to database
        require('connection.php');

        $addGroupData = array();
        $userID = NULL;
        $loggedIn = NULL;

        foreach ($_POST as $key => $value) {
            if ($key === 'userID' && isset($value) && !empty($value) && $value !== 'null') {
                $userID = $value;
            } elseif ($key === 'loggedIn' && isset($value) && !empty($value) && $value !== 'null') {
                $loggedIn = $value;
            } elseif (empty($value) || $value === 'null') {
                $addGroupData[] = null;
            } else {
                // Otherwise, append cleaned value
                $trimmedValue = trim($value);
                $escapedValue = $mysqli->real_escape_string($trimmedValue);
                $addGroupData[] = $escapedValue;
            }
        }

        // addGroupData
        // [0] = group name
        // [1] = category id
        // [2] = location name
        // [3] = latitude
        // [4] = longitude
        // [5] = group description

        if ($userID && $loggedIn) {
            // Set timezone to create date variables
            date_default_timezone_set('America/Chicago');
            $dateCreated = date('Y-m-d H:i:s');
            $dateUpdated = date('Y-m-d H:i:s');

            $addGroupQuery = $mysqli->prepare('INSERT INTO `groups`
            (`group_name`, `category_id`, `location_name`, `latitude`, `longitude`,
            `description`, `user_id`, `date_created`, `date_updated`)
            VALUES (?,?,?,?,?,?,?,?,?)');

            if (
                $addGroupQuery &&
                $addGroupQuery->bind_param(
                    'sisddssss',
                    $addGroupData[0],   // group name
                    $addGroupData[1],   // category id
                    $addGroupData[2],   // location name
                    $addGroupData[3],   // latitude
                    $addGroupData[4],   // longitude
                    $addGroupData[5],   // group description
                    $userID,
                    $dateCreated,
                    $dateUpdated
                ) &&
                $addGroupQuery->execute()
            ) {
                echo json_encode('success');
            } else {
                echo json_encode($mysqli->error);
            }

            $addGroupQuery->close();
        } else {
            echo json_encode('Error: No Add Groups data!');
        }
        $mysqli->close();
    } else {
        echo json_encode('Error: No Add Groups info!');
    }
} else {
    echo json_encode('Error: Add Groups!');
}
