<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       checkGroupCategory.php
DESCRIPTION:    
*/

$message = 'Check Group Category Error';

// make sure we have received a get request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $info = json_decode($data);

        // Check that object is set and not empty
        if (isset($info) && !empty($info)) {

            // Require database connection
            require('connection.php');

            $userID = $info->userID;
            $loggedIn =  $info->loggedIn;
            $categoryName = $mysqli->real_escape_string($info->categoryName);

            if ($userID && $loggedIn && $categoryName) {
                // initialize database query
                $selectCheckCategoryQuery = $mysqli->prepare('SELECT COUNT(*) AS `count`
                                                            FROM `groups` AS g
                                                            JOIN `group_categories` AS gc
                                                            ON g.category_id = gc.id
                                                            WHERE gc.category_name = ?
                                                            AND g.user_id = ?');

                // if query can prepare, parameters can bind and query can execute, proceed
                if (
                    $selectCheckCategoryQuery &&
                    $selectCheckCategoryQuery->bind_param(
                        'ss',
                        $categoryName,
                        $userID
                    ) &&
                    $selectCheckCategoryQuery->execute()
                ) {

                    // grab result from query and close query
                    $categoryResult = $selectCheckCategoryQuery->get_result();
                    $result = $categoryResult->fetch_assoc();
                    $selectCheckCategoryQuery->close();

                    $message = $result['count'];
                } else {
                    $message = $mysqli->error;
                }
            } else {
                $message = 'No values';
            }

            $mysqli->close();
        } else {
            $message = 'No info';
        }
    } else {
        $message = ' No data';
    }
}

echo json_encode($message);
