<?php
require('accessControl.php');
$mysqli;
require('connection.php');


/*
BY:             krn
FILE:           createAnimals.php
DESCRIPTION:
*/


$groupID = NULL;
$userID = NULL;
$additionType = NULL;

// define local time zone and format
date_default_timezone_set('America/Chicago');
// set date created for record insertion
$dateCreated = date('Y-m-d H:i:s');
$dateUpdated = date('Y-m-d H:i:s');

function updateGroup()
{
    global $mysqli;
    global $groupID;
    global $userID;
    global $dateUpdated;

    if ($groupID && $userID) {
        $updateGroupQuery = $mysqli->prepare(
            'UPDATE `groups` AS `g`
            SET `g`.`date_updated` = ?
            WHERE `g`.`id` = ?
            AND `g`.`user_id` = ?'
        );


        if (
            $updateGroupQuery &&
            $updateGroupQuery->bind_param(
                'sis',
                $dateUpdated,
                $groupID,
                $userID
            ) &&
            $updateGroupQuery->execute()
        ) {
            $updateGroupQuery->close();
            return true;
        } else {
            $updateGroupQuery->close();
            return false;
        }
    } else {
        echo json_encode('Error: No Group ID or User ID');
        exit(1);
    }
}

function animalToGroup($animalID)
{
    global $mysqli;
    global $groupID;
    global $userID;
    global $dateCreated;

    // check to see if we successfully inserted a new animal and have their id from the database record
    if ($animalID && $groupID) {

        $addGroupAnimalsQuery = $mysqli->prepare('INSERT INTO `group_animals`
                                                (`group_id`, `animal_id`, `user_id`, `entry_date`)
                                                VALUES (?,?,?,?)');

        if (
            $addGroupAnimalsQuery &&
            $addGroupAnimalsQuery->bind_param(
                'iiss',
                $groupID,
                $animalID,
                $userID,
                $dateCreated
            ) &&
            $addGroupAnimalsQuery->execute()
        ) {
            $addGroupAnimalsQuery->close();
            return true;
        } else {
            $addGroupAnimalsQuery->close();
            return false;
        }
    } else {
        echo json_encode('Error: No Animal ID or Group ID');
        exit(1);
    }
}

function createAnimals($prefix, $count, $sexID, $birthDate, $purchaseDate)
{
    global $mysqli;
    global $userID;
    global $additionType;
    global $dateCreated;
    global $dateUpdated;

    // NOTE: Functionality related to record types has not been implemented (AS OF JAN. 2023)
    // INITIALIZE AS DEFAULT; STATIC FOR TESTING REMOVE BEFORE PRODUCTION
    // record type (1 = full access)
    $recordTypeID = 1;

    // insert new animal record into animals table in database
    $addAnimalQuery = $mysqli->prepare('INSERT INTO `animals`
                                        (`primary_id`, `sex_id`, `addition_type`, `date_birth`, `date_purchase`,
                                        `status_id`, `reason_id`, cause_id, `user_id`,
                                        `record_type_id`, `date_created`, `date_updated`)
                                        VALUES (?,?,?,?,?,?,?,?,?,?,?,?)');

    // define prefix for naming animals (prefix-count, i.e. apple-2)
    $setPrefix = $prefix . '-' . $count;

    // default status ID to 1 (Active) when user is adding multiple animals (automated)
    $defaultStatus = 1;
    // default reason ID to 1 (default for Active) when user is adding multiple animals (automated)
    $defaultReason = 1;
    // default cause ID to 1 (default for Active) when user is adding multiple animals (automated)
    $defaultCause = 1;

    // if query can prepare, parameters can bind and query can execute, proceed
    if (
        $addAnimalQuery &&
        $addAnimalQuery->bind_param(
            'siissiiisiss',
            $setPrefix,
            $sexID,
            $additionType,
            $birthDate,
            $purchaseDate,
            $defaultStatus,
            $defaultReason,
            $defaultCause,
            $userID,
            $recordTypeID,
            $dateCreated,
            $dateUpdated
        ) &&
        $addAnimalQuery->execute()
    ) {
        // close query to add animal
        $addAnimalQuery->close();

        // grab database record id for new animal
        $animalID = $mysqli->insert_id;

        if ($animalID) {
            if (animalToGroup($animalID)) {
                return;
            } else {
                echo json_encode('Error: Unsuccessful in associating animal to group');
                exit(1);
            }
        } else {
            echo json_encode('Error: No Animal ID');
            exit(1);
        }
    } else {
        echo json_encode($mysqli->error);
        exit(1);
    }
}

// make sure we have received a post request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // grab the passed data string
    $data = file_get_contents('php://input');

    // explode the data string into a list
    $items = explode(',', $data);

    // check to see if item (groupID) has a value and is not an empty string
    if (isset($items[0]) && !empty($items[0])) {
        $groupID = intval($mysqli->real_escape_string($items[0]));
    }

    // check to see if item (additionType) has a value and is not an empty string
    if (isset($items[1]) && !empty($items[1])) {
        $additionType = $mysqli->real_escape_string($items[1]);
    }

    // check to see if item (userID) has a value and is not an empty string
    if (isset($items[8]) && !empty($items[8])) {
        $userID = $mysqli->real_escape_string($items[8]);
    }

    // if we have a group id, continue, otherwise exit script
    if ($groupID && $userID && $additionType) {

        /*
        * Check to see if item (prefix) has a value and is not an empty string
        * Otherwise, set value to `created`
        */
        if (isset($items[2]) && !empty($items[2])) {
            $prefix = $mysqli->real_escape_string($items[2]);
        } else {
            $prefix = 'created';
        }

        /*
        * Check to see if item (bulls) has a value and is not an empty string
        * Otherwise, set value to 0
        */
        if (isset($items[3]) && !empty($items[3])) {
            $bulls = intval($mysqli->real_escape_string($items[3]));
        } else {
            $bulls = 0;
        }

        /*
        * Check to see if item (steers) has a value and is not an empty string
        * Otherwise, set value to 0
        */
        if (isset($items[4]) && !empty($items[4])) {
            $steers = intval($mysqli->real_escape_string($items[4]));
        } else {
            $steers = 0;
        }

        /*
        * Check to see if item (cows) has a value and is not an empty string
        * Otherwise, set value to 0
        */
        if (isset($items[5]) && !empty($items[5])) {
            $cows = intval($mysqli->real_escape_string($items[5]));
        } else {
            $cows = 0;
        }

        /*
        * Check to see if item (birthDate) has a value and is not an empty string
        * Otherwise, set value to NULL
        */
        if (isset($items[6]) && !empty($items[6])) {
            $birthDate = $mysqli->real_escape_string($items[6]);
        } else {
            $birthDate = NULL;
        }

        /*
        * Check to see if item (purchaseDate) has a value and is not an empty string
        * Otherwise, set value to NULL
        */
        if (isset($items[7]) && !empty($items[7])) {
            $purchaseDate = $mysqli->real_escape_string($items[7]);
        } else {
            $purchaseDate = NULL;
        }

        // initialize count to 1
        $count = 1;

        /*
        * If any of our sexes have a value greater than 0
        * Then, calculate total animals to be added
        */
        if ($bulls > 0 || $steers > 0 || $cows > 0) {
            $totalAnimals = $bulls + $steers + $cows;
        } else {
            // else, none of the animals have a value, default to 0
            $totalAnimals = 0;
        }

        /*
        * If our amount of total animals is greater than 0
        * Then, loop until amount of all sexes have been added
        */
        if ($totalAnimals > 0) {
            while ($count < $totalAnimals) {

                while ($bulls > 0) {
                    createAnimals($prefix, $count, 1, $birthDate, $purchaseDate);
                    $bulls--;
                    $count++;
                }

                while ($steers > 0) {
                    createAnimals($prefix, $count, 2, $birthDate, $purchaseDate);
                    $steers--;
                    $count++;
                }

                while ($cows > 0) {
                    createAnimals($prefix, $count, 3, $birthDate, $purchaseDate);
                    $cows--;
                    $count++;
                }
            }
        } else {
            echo json_encode('Error: No Animals to Create');
            exit(1);
        }

        if ($bulls === 0 && $steers === 0 && $cows === 0) {
            // After all animals have been added, update the `date_updated` field for the groups table
            if (updateGroup()) {
                echo json_encode('success');
            } else {
                echo json_encode('Error: Unable to Update Group with Created Animals');
                exit(1);
            }
        } else {
            echo json_encode($mysqli->error);
            exit(1);
        }
    } else {
        echo json_encode('Error: No Group ID or No User ID or No Addition Type');
        exit(1);
    }

    // returns the thread id for the current connection
    $thread = $mysqli->thread_id;

    // kills the thread id for the current connection
    $mysqli->kill($thread);

    // closes the sql database connection
    $mysqli->close();
}
