<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       deleteGroupCategory.php
DESCRIPTION:    
*/

$message = 'Delete Group Category Error';

// make sure we have received a get request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $info = json_decode($data);

        // Check that object is set and not empty
        if (isset($info) && !empty($info)) {

            // Require database connection
            require('connection.php');

            $categoryID = $mysqli->real_escape_string($info->categoryID);
            $userID = $mysqli->real_escape_string($info->userID);
            $loggedIn = $mysqli->real_escape_string($info->loggedIn);

            if ($userID && $loggedIn && $categoryID) {

                // initialize database query
                $deleteCategoryQuery = $mysqli->prepare('DELETE FROM `group_categories` AS gc
                                                        WHERE gc.id = ?
                                                        AND gc.user_id = ?');

                // if query can prepare, parameters can bind and query can execute, proceed
                if (
                    $deleteCategoryQuery &&
                    $deleteCategoryQuery->bind_param(
                        'is',
                        $categoryID,
                        $userID
                    ) &&
                    $deleteCategoryQuery->execute()
                ) {

                    // check the affected rows (number)
                    $affectedRows = $mysqli->affected_rows;

                    // close query
                    $deleteCategoryQuery->close();

                    // if our affected rows is equal to 1, echo (return) the result (1)
                    // only one row should be affected because the user can only have a single instance of a specific category name
                    if ($affectedRows = 1) {
                        $message = $affectedRows;
                    } else {
                        $message = 'Affected Rows Error';
                    }
                } else {
                    $message = $mysqli->error;
                }
            } else {
                $message = 'No values';
            }

            $mysqli->close();
        } else {
            $message = 'No info';
        }
    } else {
        $message = 'No data';
    }
}

echo json_encode($message);
