<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       editAnimals.php
DESCRIPTION:    Edit existing database record(s) for animal(s) in the `animals` table
                with the passed data from user input. On the app, the user has to tap
                'Save' for the changes to updated and this script to be triggered.
*/

$message = 'Edit Animals Error';

// make sure we have received a post request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    require('connection.php');

    // Define array to hold our edit animal form data
    $editAnimalData = array();
    $userID = NULL;
    $loggedIn = NULL;

    // iterate through posted data as key -> value pairing
    foreach ($_POST as $key => $value) {

        // If the current `$key` is `userID` set $userID value
        if ($key === 'userID' && isset($value) && !empty($value) && $value !== 'null') {
            $userID = $value;
        }
        // Else if, the current `$key` is `loggedIn` set $loggedIn value
        elseif ($key === 'loggedIn' && isset($value) && !empty($value) && $value !== 'null') {
            $loggedIn = $value;
        } elseif ($key === 'id') {
            /*
            * Else if, the current key is `id`
                make sure there is a value and set the id
                for our animal (database record id) to be used later
            */
            if (isset($value) && !empty($value) && $value !== 'null') {
                $animalID = intval($mysqli->real_escape_string($value));
            } else {
                echo json_encode('Error: No Animals ID');
                $mysqli->close();
                exit(1);
            }
        } elseif ($key === 'date') {
            /*
            * If the current key is `date` and there is a value
            * Trim, escape, convert string to time, append to data array
            * Else, append NULL
            */
            if (isset($value) && !empty($value) && $value !== 'null') {
                // Trim the value to remove whitespace from both sides
                $trimmedValue = trim($value);

                // Escape the trimmed value
                $escapedValue = $mysqli->real_escape_string($trimmedValue);

                // Convert the escaped value to date format 'Y-m-d'
                $formattedDate = date('Y-m-d', strtotime($escapedValue));

                // Append the formatted date to the array
                $editAnimalData[] = $formattedDate;
            } else {
                // Append null value to the array
                $editAnimalData[] = null;
            }
        } else {
            /*
            * If the value is empty ('') or 'null'
            * (setting value to null on form encodes to string when passed)
            */
            if (empty($value) || $value === 'null') {
                $value = NULL;
            } else {
                // Otherwise, append cleaned value
                $trimmedValue = trim($value);
                $escapedValue = $mysqli->real_escape_string($trimmedValue);
                $value = $escapedValue;
            }

            // Append value to data list
            $editAnimalData[] = $value;
        }
    }

    if ($userID && $loggedIn) {
        $message = count($editAnimalData);
        // Define local time zone and format
        date_default_timezone_set('America/Chicago');

        // Set date created for record insertion
        $dateUpdated = date('Y-m-d H:i:s');

        if ((isset($animalID) && !empty($animalID)) && (isset($userID) && !empty($userID))) {
            $updateAnimalQuery = $mysqli->prepare('UPDATE `animals` AS `a`
                                                    SET `primary_id` = ?, `sex_id` = ?, `addition_type` = ?,
                                                    `date_birth` = ?, `date_purchase` = ?, `breed_id` = ?, `color_id` = ?, `weight` = ?,
                                                    `tag_color` = ?, `official_nues` = ?, `official_ain` = ?,
                                                    `twin_status_id` = ?, `calving_vigor_score_id` = ?, `dam` = ?,
                                                    `teat_score_id` = ?, `udder_score_id` = ?, `calving_ease_id` = ?,
                                                    `dam_bcs_id` = ?, `sire` = ?, `status_id` = ?, `reason_id` = ?,
                                                    `cause_id` = ?, `notes` = ?, `date_updated` = ?
                                                    WHERE `a`.`id` = ? AND `a`.`user_id` = ?');

            // If the query can prepare, bind parameters, and execute, then continue
            if (
                $updateAnimalQuery &&
                $updateAnimalQuery->bind_param(
                    'siissiidsssiiiiiiiiiiissss',
                    $editAnimalData[0],     // primary ID (animal name)
                    $editAnimalData[1],     // sex ID
                    $editAnimalData[2],     // addition type (birth [1] or purchase [2])
                    $editAnimalData[3],     // date of birth
                    $editAnimalData[4],     // date of purchase
                    $editAnimalData[5],     // breed ID
                    $editAnimalData[6],     // color ID
                    $editAnimalData[7],     // weight (lbs)
                    $editAnimalData[8],     // tag color
                    $editAnimalData[9],     // official NUES (national uniform ear-tagging system) [15 characters]
                    $editAnimalData[10],    // official AIN (animal identification number) [8-9 characters]
                    $editAnimalData[11],    // twin status ID
                    $editAnimalData[12],    // calving vigor score ID
                    $editAnimalData[13],    // dam ID (referenced animal ID, selected by user)
                    $editAnimalData[14],    // teat score ID
                    $editAnimalData[15],    // udder score ID
                    $editAnimalData[16],    // calving ease ID
                    $editAnimalData[17],    // dam body condition score
                    $editAnimalData[18],    // sire ID (referenced animal ID, selected by user)
                    $editAnimalData[19],    // status id (active/inactive)
                    $editAnimalData[20],    // reason id (related to inactive status)
                    $editAnimalData[21],    // cause id (related to reason of inactive status)
                    $editAnimalData[22],    // notes
                    $dateUpdated,           // date updated (0000-00-00 00:00:00)
                    $animalID,              // animal ID
                    $userID                 // user ID
                ) &&
                $updateAnimalQuery->execute() &&
                $updateAnimalQuery->affected_rows === 1
            ) {
                $message = 'success';
                $updateAnimalQuery->close();
            } else {
                $message = $mysqli->error;
                $updateAnimalQuery->close();
            }
        } else {
            $message = 'No User ID or Group Animals ID!';
        }
    } else {
        $message = 'Not logged in!';
    }
}

echo json_encode($message);
$mysqli->close();
