<?php
require('accessControl.php');

/*
BY:             krn
FILE:           addGroups.php
DESCRIPTION:    Update group information in the database. Accepts form data submitted via a POST request,
                validating and sanitizing the input, and then updating the group in the database table `groups`.
                The script checks if the user is logged in and returns a response message based on the success or failure of the update process.
                Only one (1) record should be updated, based on the ID of the group in the database `groups` table.
*/


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST) && !empty($_POST)) {
        // Connect to database
        require('connection.php');

        $editGroupData = array();
        $userID = NULL;
        $loggedIn = NULL;
        $groupID = NULL;

        foreach ($_POST as $key => $value) {
            if ($key === 'userID' && isset($value) && !empty($value) && $value !== 'null') {
                $userID = $value;
            } elseif ($key === 'loggedIn' && isset($value) && !empty($value) && $value !== 'null') {
                $loggedIn = $value;
            } elseif ($key === 'groupID' && isset($value) && !empty($value) && $value !== 'null') {
                $groupID = intval($mysqli->real_escape_string($value));
            } elseif (empty($value) || $value === 'null') {
                $editGroupData[] = null;
            } else {
                // Otherwise, append cleaned value
                $trimmedValue = trim($value);
                $escapedValue = $mysqli->real_escape_string($trimmedValue);
                $editGroupData[] = $mysqli->real_escape_string($escapedValue);
            }
        }

        if ($userID && $loggedIn && $groupID) {
            // Set timezone to create date variables
            date_default_timezone_set('America/Chicago');
            $dateUpdated = date('Y-m-d H:i:s');

            $updateGroupQuery = $mysqli->prepare('UPDATE `groups` AS `g`
                                                SET `g`.`group_name` = ?, `g`.`category_id` = ?, 
                                                `g`.`location_name` = ?, `g`.`latitude` = ?, 
                                                `g`.`longitude` = ?, `g`.`description` = ?, `g`.`date_updated` = ?
                                                WHERE `g`.`id` = ? AND `g`.`user_id` = ?');

            if (
                $updateGroupQuery &&
                $updateGroupQuery->bind_param(
                    'sisddssis',
                    $editGroupData[0],   // group name
                    $editGroupData[1],   // category id
                    $editGroupData[2],   // location name
                    $editGroupData[3],   // latitude
                    $editGroupData[4],   // longitude
                    $editGroupData[5],   // group description
                    $dateUpdated,
                    $groupID,
                    $userID
                ) &&
                $updateGroupQuery->execute() &&
                $updateGroupQuery->affected_rows === 1
            ) {
                echo json_encode('success');
            } else {
                echo json_encode($mysqli->error);
            }

            $updateGroupQuery->close();
        } else {
            echo json_encode('Error: No Edit Group data!');
        }
        $mysqli->close();
    } else {
        echo json_encode('Error: No Edit Group info!');
    }
} else {
    echo json_encode('Error: Edit Group!');
}
