<?php

/*
BY:             krn
FILE:           eventLog.php
DESCRIPTION:    
*/

// define local time zone and format
date_default_timezone_set('America/Chicago');

function addLog($mysqli, $actionTypeID, $eventID, $userID)
{
    // set date created/updated for record insertion
    $logDateTime = date('Y-m-d H:i:s');

    $insertLogQuery = $mysqli->prepare('INSERT INTO `log` (`action_type`, `event_id`, `user_id`, `log_datetime`) VALUES (?,?,?,?)');

    if (
        $insertLogQuery &&
        $insertLogQuery->bind_param(
            'iiss',
            $actionTypeID,
            $eventID,
            $userID,
            $logDateTime
        ) &&
        $insertLogQuery->execute()
    ) {
        if ($mysqli->affected_rows !== 1) {
            echo json_encode('Incorrect number of rows affected for Log.');
            exit(1);
        } else {
            return true;
        }
    } else {
        echo json_encode('Insert event log record error: ' . $mysqli->error);
        exit(1);
    }
}

function addEventMove($mysqli, $actionTypeID, $actionsID, $currentGroupID, $previousGroupID, $itemID, $userID)
{

    // set date created/updated for record insertion
    $eventDateTime = date('Y-m-d H:i:s');

    $insertEventQuery = $mysqli->prepare('INSERT INTO `event_move`
    (`action_type_id`, `actions_id`, `current_group_id`, `previous_group_id`,
    `animal_id`, `user_id`, `event_datetime`)
    VALUES (?,?,?,?,?,?,?)');

    if (
        $insertEventQuery &&
        $insertEventQuery->bind_param(
            'iiiiiss',
            $actionTypeID,
            $actionsID,
            $currentGroupID,    // current group ID
            $previousGroupID,   // previous group ID (at time of event log insertion)
            $itemID,            // animal ID
            $userID,
            $eventDateTime
        ) &&
        $insertEventQuery->execute()
    ) {
        if ($mysqli->affected_rows !== 1) {
            echo json_encode('Incorrect number of rows affected for Event Move.');
            exit(1);
        } else {
            return $mysqli->insert_id;
        }
    } else {
        echo json_encode('Insert event log record error: ' . $mysqli->error);
        exit(1);
    }
}

function selectAction($mysqli, $actionTypeID, $actionItem, $actionAmount)
{
    $actionsID = 0;

    $selectActionQuery = $mysqli->prepare('SELECT `id`
    FROM `actions`
    WHERE `action_type_id` = ?
    AND `item` = ?
    AND `amount` = ?');

    if (
        $selectActionQuery &&
        $selectActionQuery->bind_param(
            'iss',
            $actionTypeID,
            $actionItem,
            $actionAmount
        ) &&
        $selectActionQuery->execute()
    ) {
        $selectActionQuery->bind_result($actionsID);
        $selectActionQuery->fetch();
        return $actionsID;
    } else {
        echo json_encode('Select action ID Error: ' . $mysqli->error);
        $mysqli->close();
        exit(1);
    }
}

function createEvent($mysqli, $actionTypeID, $values, $userID)
{
    try {
        /*
        $actionTypeID:
            - refers to type of action being preformed, e.g. (Move = 1, Health = 2, etc.)
        $values: [$item, $amount, $oldGroupIDs, $newGroupID, $itemIDs]
            [0] = item (animals OR groups)
            [1] = amount (single OR multiple)
            [2] = list of old group IDs for items [[3], [4]]
            [3] = new group id selected by user, e.g. [63]
            [4] = item ids
                - if animals, animals ids being modified
                - if groups, then this is an array of arrays (animal ids from groups being changed)
        */

        // make sure we can log in to database, if not exit, otherwise continue
        if ($mysqli->connect_errno) {
            die('Connect Error: ' . $mysqli->connect_errno);
        }

        // if we have an actionTypeID, proceed with determine which action is being applied
        if ($actionTypeID) {
            $item = $values[0];
            $amount = $values[1];
            $actionsID = selectAction($mysqli, $actionTypeID, $item, $amount);

            // Move (to Group) action type (1)
            if ($actionTypeID === 1) {
                $oldGroupID = $values[2];

                // Example of one animal in multiple groups: [['15', '16']]
                // Example of multiple animals in multiple/single groups: [['15','16'], ['16','17'], [17]]
                // echo json_encode($oldGroupIDs[0]);

                $newID = $values[3];

                if ($item === 'animals') {
                    $animalIDs = $values[4];
                    /*
                    * Iterate through old group ids list as key/value pair
                        use key for indexing purpose and accessing item of item IDs list as well
                    * Item IDs will either be animal ids or group ids
                    */
                    foreach ($animalIDs as $value) {
                        /*
                        * Possible for item (animal) to exist in multiple groups
                        * Assume that if the user has chosen the animal from the `All Animals` view then that means they want to move the group
                        * From ALL current groups to the newly selected group
                        * NOTE, this might need to be changed later, but is correct as of September 16, 2020
                        * `ogi` = Old Group ID
                        */
                        $eventInsertID = addEventMove(
                            $mysqli,
                            $actionTypeID,
                            $actionsID,
                            $newID,
                            $oldGroupID,
                            $value,
                            $userID
                        );

                        if (!$eventInsertID) {
                            echo json_encode('Error inserting event record.');
                            $mysqli->close();
                            exit(1);
                        } else {
                            $logResult = addLog($mysqli, $actionTypeID, $eventInsertID, $userID);

                            if (!$logResult) {
                                echo json_encode('Error inserting log record.');
                                $mysqli->close();
                                exit(1);
                            }
                        }
                    }
                }
                // elseif ($item === 'groups') {
                //     $allOldGroupAnimals = $values[4];
                //     // If we are dealing with groups, then grab all animals for groups
                //     // iterate through the `itemIDs` (group ids) as key/value pair
                //     foreach ($allOldGroupAnimals as $gaKey => $gaValue) {
                //         // if we have a result of group animals
                //         if (count($gaValue) > 0) {
                //             // iterate through the group animals as a key/value pair
                //             foreach ($gaValue as $value) {
                //                 $eventResult = addEventMove(
                //                     $mysqli,
                //                     $actionTypeID,
                //                     $actionsID,
                //                     $newID,
                //                     $oldGroupID,
                //                     $value,
                //                     $userID
                //                 );

                //                 if (!$eventResult) {
                //                     echo json_encode('Error inserting event log record.');
                //                     $mysqli->close();
                //                     exit(1);
                //                 }
                //             }
                //         }
                //     }
                // }

                // once each item has an event in the log database, return True
                return True;
            } elseif ($actionTypeID === 2) { // Apply Health action
                echo json_encode('health action');
                // } elseif ($actionTypeID === 3) { // Apply Treatment action
                //     echo json_encode('treatment action');
                // } elseif ($actionTypeID === 4) { // Apply Sell/Transfer action
                //     echo json_encode('sell transfer action');
                // } elseif ($actionTypeID === 5) { // Apply Disable action
                //     echo json_encode('disable action');
            } elseif ($actionTypeID === 0 || $actionTypeID > 5) {
                echo json_encode('Invalid action ID.');
                $mysqli->close();
                exit(1);
            }
        } else {
            echo json_encode('Invalid action ID.');
            $mysqli->close();
            exit(1);
        }
    } catch (Exception $ex) {
        echo json_encode('Exception: ' . $ex);
        $mysqli->close();
        exit(1);
    }
}
