<?php
require('accessControl.php');

/*
* BY:             krn
* FILENAME:       getExistingAnimals.php
* DESCRIPTION:    
*/

$message = 'Get Existing Animals Error';

// make sure we have received a post request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $info = json_decode($data);

        // Check that object is set and not empty
        if (isset($info) && !empty($info)) {

            // Require database connection
            require('connection.php');

            // Define variables
            $userID = $info->userID;
            $loggedIn = $info->loggedIn;
            $groupID = $info->groupID;

            // If variables have a value, continue with query
            if ($userID && $loggedIn && $groupID) {

                /* 
                * Select all the animals for a specific user that are not in the current group they are adding to
                * NOTE: Possible for animal(s) to be in multiple groups for a single user
                */
                $selectExistingAnimalsQuery = $mysqli->prepare(


                    'SELECT
                        `a`.*,
                        GROUP_CONCAT(DISTINCT `g`.`group_name`) AS `group_names`
                    FROM
                        `animals` AS `a` 
                        JOIN `group_animals` AS `ga` ON `a`.id = `ga`.`animal_id`
                        JOIN `groups` AS `g` ON `ga`.`group_id` = `g`.`id`
                    WHERE `a`.`id` NOT IN
                        (SELECT `a`.`id` FROM `animals` AS `a`
                        JOIN `group_animals` AS `ga`
                        ON `a`.`id` = `ga`.`animal_id`
                        WHERE `ga`.`group_id` = ?)
                    AND `a`.`user_id` = ?
                    GROUP BY `a`.`id`
                    ORDER BY `a`.`primary_id` ASC'
                );

                // If query can prepare, parameters can bind and query can execute, proceed
                if (
                    $selectExistingAnimalsQuery
                    &&
                    $selectExistingAnimalsQuery->bind_param(
                        'is',
                        $groupID,
                        $userID
                    )
                    &&
                    $selectExistingAnimalsQuery->execute()
                ) {

                    // Grab result from query and close query
                    $existingAnimalsResult = $selectExistingAnimalsQuery->get_result();

                    // Initialize array to hold each animal (row data)
                    $result = array();

                    // Iterate through animal result by each row and append to result array
                    while ($row = $existingAnimalsResult->fetch_assoc()) {
                        $result[] = $row;
                    }

                    $message = $result;
                } else {
                    $message = $mysqli->error;
                }

                $selectExistingAnimalsQuery->close();
            }
            $mysqli->close();
        } else {
            $message = 'No info!';
        }
    } else {
        $message = 'No data!';
    }
}

echo json_encode($message);
