<?php
require('accessControl.php');

/*
BY:             krn
FILE:           getGroupAnimals.php
DESCRIPTION:
*/

$message = 'Get Group Animals Error';

// Make sure we have received a post request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

	// Receive JSON POST from app
	$data = file_get_contents('php://input');

	// Check that data is set and not empty
	if (isset($data) && !empty($data)) {

		// Decode JSON POST data
		$info = json_decode($data);

		// Check that object is set and not empty
		if (isset($info) && !empty($info)) {

			// Require database connection
			require('connection.php');

			// Define variables
			$userID = $info->userID;
			$loggedIn = $info->loggedIn;
			$groupID = strval($info->groupID);

			// If variables have a value, continue with query
			if ($userID && $loggedIn && $groupID) {

				// Prepare sql query to grab all animals for a specific group
				$selectAnimalsQuery = $mysqli->prepare(
					'SELECT
						`a`.*,
						`s`.`name` AS `sex_name`,
						GROUP_CONCAT(DISTINCT `g`.`group_name`) AS `group_names`,
						GROUP_CONCAT(DISTINCT `ga`.`group_id`) AS `group_ids`,
						GROUP_CONCAT(DISTINCT `gc`.`category_name`) AS `category_names`,
						GROUP_CONCAT(DISTINCT `gc`.`id`) AS `category_ids`
					FROM
						`animals` AS `a` 
						JOIN `group_animals` AS `ga` ON `a`.id = `ga`.`animal_id`
						JOIN `groups` AS `g` ON `ga`.`group_id` = `g`.`id`
						JOIN `group_categories` AS `gc` ON `g`.`category_id` = `gc`.`id`
						JOIN `sexes` AS `s` ON `a`.`sex_id` = `s`.`id`
					WHERE `a`.`user_id` = ?
					GROUP BY `a`.`id`
					ORDER BY `a`.`primary_id` ASC'
				);

				/*
				* Grab all animals associated with the current user
				* Make sure we can prepare query, bind parameter, and execute query
				*/
				if (
					$selectAnimalsQuery &&
					$selectAnimalsQuery->bind_param(
						's',
						$userID
					) &&
					$selectAnimalsQuery->execute()
				) {

					// grab result from query and close query
					$animalResult = $selectAnimalsQuery->get_result();

					// initialize array to hold each animal (row data)
					$result = array();

					// Iterate through animal result by each row; append to result array
					/*
					* NOTE: Since the Query select ALL ANIMALS based on the $userID, we have to filter out the animals that
						actually have the group ID in their `group_ids` value
					*/
					while ($row = $animalResult->fetch_assoc()) {

						/*
						* Initialize variable to check and see if the current animal's `group_ids` 
							contain the passed group ID from the user of the animals they are trying to select
						*/
						$isGroupAnimal = false;

						/*
						* Check to see if there are multiple group IDs in the resulting animals
							- e.g., a comma (",") will exist in the $row[`group_ids`] value
						* If a comma does exist, explode the $row[`group_ids`] value on the comma and create a list of group IDs `$group_ids`
						*/
						if(strpos($row['group_ids'], ",") !== false) {
							$explodedGroupIDs = explode(',', $row['group_ids']);

							if ($groupID && $explodedGroupIDs) {
								if (in_array($groupID, $explodedGroupIDs)) {
									$isGroupAnimal = true;
								}
							}
						} else {
							/*
							* Else, there was not a comma in the `group_ids` value
								so there must only be 1 group ID associated with the current animal
							*/

							/*
							* If the value of `group_ids` for the current animal is equal to the passed `$groupID` value from the user
								then we are dealing with an appropriate group animal
							*/
							if ($row['group_ids'] === $groupID) {
								$isGroupAnimal = true;
							}
						}

						// If the current animal IS an animal in the group selected by the user (passed `$groupID` value)
						if ($isGroupAnimal) {
							// if the current animal has a value for dam
							// then, we need to use that value to grab the name of the animal that is the dam
							// to display back to the user when they view animal data
							if ($row['dam']) {

								// prepare query to grab name of animal that matches dam id associated
								// with current animal from group of animals linked to user's account
								$selectAnimalDamQuery = $mysqli->prepare('SELECT a1.primary_id AS dam_name
																		FROM `animals` AS `a`
																		JOIN `animals` as `a1`
																		ON a.dam = a1.id
																		WHERE a.dam = ?');

								// if the query was prepared, parameters bind, and executed successfully
								// then, create a new item in our row to hold the name of the animal as `dam_name`
								// close the query once we have the result
								if (
									$selectAnimalDamQuery &&
									$selectAnimalDamQuery->bind_param('i', $row['dam']) &&
									$selectAnimalDamQuery->execute()
								) {
									$damResult = $selectAnimalDamQuery->get_result();
									$damResult = $damResult->fetch_assoc();
									$row['dam_name'] = $damResult['dam_name'];
								}

								$selectAnimalDamQuery->close();
							}

							// if the current animal has a value for sire
							// then, we need to use that value to grab the name of the animal that is the sire
							// to display back to the user when they view animal data
							if ($row['sire']) {

								// prepare query to grab name of animal that matches sire id associated
								// with current animal from group of animals linked to user's account
								$selectAnimalSireQuery = $mysqli->prepare('SELECT a1.primary_id AS sire_name
																		FROM `animals` AS `a`
																		JOIN `animals` as `a1`
																		ON a.sire = a1.id
																		WHERE a.sire = ?');

								// if the query was prepared, parameters bind, and executed successfully
								// then, create a new item in our row to hold the name of the animal as `sire_name
								// close the query once we have the result
								if (
									$selectAnimalSireQuery &&
									$selectAnimalSireQuery->bind_param('i', $row['sire']) &&
									$selectAnimalSireQuery->execute()
								) {
									$sireResult = $selectAnimalSireQuery->get_result();
									$sireResult = $sireResult->fetch_assoc();
									$row['sire_name'] = $sireResult['sire_name'];
								}

								$selectAnimalSireQuery->close();
							}

							// Append current row to results array
							$result[] = $row;
						}
					}

					$message = $result;
				} else {
					$message = $mysqli->error;
				}

				$selectAnimalsQuery->close();
			} else {
				$message = 'No values!';
			}

			$mysqli->close();
		} else {
			$message = 'No info!';
		}
	} else {
		$message = 'No data!';
	}
}

echo json_encode($message);
