<?php
require('accessControl.php');

/*
* BY:           krn
* FILENAME:     getGroupCategories.php
* DESCRIPTION:  Get all group categories for the current user, based on the passed `userID`. Pass list of group categories back to application.
*/

// make sure we have received a get request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $info = json_decode($data);

        // Check that object is set and not empty
        if (isset($info) && !empty($info)) {

            // Require database connection
            require('connection.php');

            // Define variables
            $userID = $info->userID;
            $loggedIn = $info->loggedIn;

            // If variables have a value, continue with query
            if ($userID && $loggedIn) {

                // Prepare `select group categories` query
                $selectGroupCategoriesQuery = $mysqli->prepare('SELECT * FROM `group_categories` 
                                                                WHERE `user_id` = ?'
                );

                /*
                * Get all group categories associated with the current user (`$userID`)
                * If the query can be prepared, parameters can be bind, and query can execute, continue with results
                */
                if (
                    $selectGroupCategoriesQuery &&
                    $selectGroupCategoriesQuery->bind_param('s', $userID) &&
                    $selectGroupCategoriesQuery->execute()
                ) {

                    // Get result from query and close query
                    $categoriesResult = $selectGroupCategoriesQuery->get_result();
                    $selectGroupCategoriesQuery->close();

                    // Initialize array to hold each group (row data)
                    $result = array();

                    // Iterate through animal result by each row and append to result array
                    while ($row = $categoriesResult->fetch_assoc()) {
                        $result[] = $row;
                    }

                    // Echo (return) array of group categories for the current user
                    echo json_encode($result);
                } else {
                    /*
                    * Else, query failed to prepare, bind or execute
                    * Echo (return) mysqli error
                    */
                    echo json_encode($mysqli->error);
                    exit(1);
                }
            } else {
                echo json_encode('No user ID');
                exit(1);
            }

            // Close database connection
            $mysqli->close();
        } else {
            echo json_encode('No info!');
        }
    } else {
        echo json_encode('No data!');
    }
}
