<?php
require('accessControl.php');

/*
* BY:             krn
* FILENAME:       renameCategory.php
* DESCRIPTION:    
*/

$message = 'Rename Group Category Error';

// make sure we have received a get request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $info = json_decode($data);

        // Check that object is set and not empty
        if (isset($info) && !empty($info)) {

            // Require database connection
            require('connection.php');

            // initialize variables from posted data
            $categoryRename = $mysqli->real_escape_string($info->rename);
            $categoryID = intval($mysqli->real_escape_string($info->categoryID));
            $userID = $info->userID;
            $loggedIn = $info->loggedIn;

            if ($userID && $loggedIn && $categoryRename && $categoryID) {

                // define local time zone and format
                date_default_timezone_set('America/Chicago');
                // set date created for record insertion
                $dateUpdated = date('Y-m-d H:i:s');

                $updateCategoryQuery = $mysqli->prepare(
                    'UPDATE `group_categories` AS `gc`
                    SET `gc`.`category_name` = ?, `gc`.`date_updated` = ?
                    WHERE `gc`.`id` = ? AND `gc`.`user_id` = ?'
                );

                // if query is valid, parameters can bind and query can be execute, continue
                if (
                    $updateCategoryQuery &&
                    $updateCategoryQuery->bind_param(
                        'ssis',
                        $categoryRename,
                        $dateUpdated,
                        $categoryID,
                        $userID
                    ) &&
                    $updateCategoryQuery->execute()
                ) {

                    // check the affected rows (number)
                    $affectedRows = $mysqli->affected_rows;

                    // close query
                    $updateCategoryQuery->close();

                    // if our affected rows is equal to 1, echo (return) the result (1)
                    // only one row should be affected because the user can only have a single instance of a specific category name
                    if ($affectedRows == 1) {
                        $message = $affectedRows;
                    } else {
                        $message = 'Rename Group Category Affected Rows Error';
                    }
                } else {
                    $message = $mysqli->error;
                }
            } else {
                $message = 'No values';
            }
            $mysqli->close();
        } else {
            $message = 'No info';
        }
    } else {
        $message = 'No data';
    }
}

echo json_encode($message);
