<?php
require('accessControl.php');

/*
BY:             krn
FILENAME:       updateGroupCategories.php
DESCRIPTION:    
*/

$message = 'Update Group Category Error';

// make sure we have received a get request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $info = json_decode($data);

        // Check that object is set and not empty
        if (isset($info) && !empty($info)) {

            // Require database connection
            require('connection.php');

            $oldCategoryID = $mysqli->real_escape_string($info->oldCategoryID);
            $newCategoryID = $mysqli->real_escape_string($info->newCategoryID);
            $userID = $mysqli->real_escape_string($info->userID);
            $loggedIn = $mysqli->real_escape_string($info->loggedIn);

            if ($userID && $loggedIn && $oldCategoryID && $newCategoryID) {
                // initialize database query
                $updateGroupCategoryQuery = $mysqli->prepare('UPDATE `groups` AS g
                                                            SET g.category_id = ?
                                                            WHERE g.category_id = ?
                                                            AND g.user_id = ?');

                // if query can prepare, parameters can bind and query can execute, proceed
                if (
                    $updateGroupCategoryQuery &&
                    $updateGroupCategoryQuery->bind_param(
                        'iis',
                        $newCategoryID,
                        $oldCategoryID,
                        $userID
                    ) &&
                    $updateGroupCategoryQuery->execute()
                ) {

                    // check the affected rows (number)
                    $updateResult = $mysqli->affected_rows;
                    $updateGroupCategoryQuery->close();

                    // we should have updated at least 1 row in the groups table
                    if ($updateResult >= 1) {

                        // next, delete the old category (one that was replaced)
                        // initialize database query
                        $deleteCategoryQuery = $mysqli->prepare('DELETE FROM `group_categories` AS gc
                                                                WHERE gc.id = ?
                                                                AND gc.user_id = ?');

                        // if query can prepare, parameters can bind and query can execute, proceed
                        if (
                            $deleteCategoryQuery &&
                            $deleteCategoryQuery->bind_param(
                                'is',
                                $oldCategoryID,
                                $userID
                            ) &&
                            $deleteCategoryQuery->execute()
                        ) {

                            // check the affected rows (number)
                            $deleteResult = $mysqli->affected_rows;
                            $deleteCategoryQuery->close();

                            // only one row should be affected because the user can only have a single instance of
                            // a specific category name
                            if ($deleteResult = 1) {
                                $message = 'success';
                            } else {
                                $message = 'Update Category Delete Error';
                            }
                        } else {
                            $message = $mysqli->error;
                        }
                    } else {
                        $message = 'Update Result Error';
                    }
                } else {
                    $message = $mysqli->error;
                }
            } else {
                $message = 'No values';
            }

            $mysqli->close();
        } else {
            $message = 'No info';
        }
    } else {
        $message = 'No data';
    }
}

echo json_encode($message);
