<?php
session_start();
require('../app/accessControl.php');

/*
* Check to see that the requested method from the app was a POST
* NOTE:
* iOS and Android may send `OPTIONS` request instead of `POST`
*/
if ($_SERVER['REQUEST_METHOD'] === 'POST' || $_SERVER['REQUEST_METHOD'] === 'OPTIONS') {

    // Set default message;
    $message = 'Error: Login failed! Please try again.';

    // Receive JSON POST from app
    $data = file_get_contents('php://input');

    // Check that passed data is set and not empty
    if (isset($data) && !empty($data)) {

        // Decode JSON POST data
        $credentials = json_decode($data);

        // Check that object is set and not empty
        if (isset($credentials) && !empty($credentials)) {

            // Include scripts for database connection and check password using passed values
            require('src/db.php');
            require('src/checkPassword.php');

            // Escape special characters in values
            $email = $em->real_escape_string($credentials->email);
            $password = $em->real_escape_string($credentials->password);

            /*
            * If the email and password are set and not empty
                check to see that the user exists in the database
            * Else, set error message
            */
            if (isset($email, $password) && !empty($email) && !empty($password)) {

                // Call function to check email and password in database
                $extID = checkPassword($em, $email, $password);

                /*
                * If there is a returned extension ID and it is set and not empty
                    then we have a user, echo extension ID (extID)
                * Else, set error message
                */
                if (isset($extID) && !empty($extID)) {

                    // Set session variables
                    $_SESSION['authenticated'] = true;
                    $_SESSION['userID'] = $extID;

                    /*
                    * Special exception for Dale Moore `gdm1` in CTO
                    * He had one of the first extension accounts created, so his username does not contain `ext-`
                    * Append `ext-` string to his username for the CALF Manager app / web portal
                    */

                    if ($extID == 'gdm1') {
                        $message = 'ext-' . $extID;
                    } else {
                        $message = $extID;
                    }
                } else {
                    $message = 'Error: Invalid credentials! Please try again.';
                }
            } else {
                $message = 'Error: No credential values! Please try again.';
            }

            // Close database connection
            $em->close();
        } else {
            $message = 'Error: No credentials! Please try again.';
        }
    } else {
        $message = 'Error: No data! Please try again.';
    }
    // Return message
    echo json_encode($message);
} else {
    // If the request method is not POST or OPTIONS, redirect user to main website
    header('Location: https://calfstewardship.extension.msstate.edu');
}
