// ==================================================
// * Project Name   :  Ajencix - Corporate Business Agency Site Template
// * File           :  JS Base
// * Version        :  1.0.0
// * Last change    :  Wednesday, September 6, 2023
// * Author         :  XtreamWebsite (https://themeforest.net/user/xtreamwebsite)
// * Developer      :  webrok (https://www.fiverr.com/webrok?up_rollout=true)
// ==================================================

(function($) {
  "use strict";

  // Back To Top - Start
  // --------------------------------------------------
  $(window).scroll(function() {
    if ($(this).scrollTop() > 200) {
      $('.backtotop:hidden').stop(true, true).fadeIn();
    } else {
      $('.backtotop').stop(true, true).fadeOut();
    }
  });
  $(function() {
    $(".scroll").on('click', function() {
      $("html,body").animate({scrollTop: 0}, "slow");
      return false
    });
  });
  // Back To Top - End
  // --------------------------------------------------

  // preloader - start
  // --------------------------------------------------
  $(window).on('load', function(){
    $('#preloader').fadeOut('slow',function(){$(this).remove();});
  });
  // preloader - end
  // --------------------------------------------------

  // sticky header - Start
  // --------------------------------------------------
  $(window).on('scroll', function () {
    if ($(this).scrollTop() > 0) {
      $('.site_header').addClass("sticky")
    } else {
      $('.site_header').removeClass("sticky")
    }
  });
  // sticky header - End
  // --------------------------------------------------

  // Dropdown - Start
  // --------------------------------------------------
  $(document).ready(function () {
    $(".dropdown").on('mouseover', function () {
      $(this).find('> .dropdown-menu').addClass('show');
    });
    $(".dropdown").on('mouseout', function () {
      $(this).find('> .dropdown-menu').removeClass('show');
    });
  });
  // Dropdown - End
  // --------------------------------------------------

  // Odometer Counter - Start
  // --------------------------------------------------
  jQuery('.odometer').appear(function (e) {
    var odo = jQuery(".odometer");
    odo.each(function () {
      var countNumber = jQuery(this).attr("data-count");
      jQuery(this).html(countNumber);
    });
  });
  // Odometer Counter - End
  // --------------------------------------------------

  // Background Parallax - Start
  // --------------------------------------------------
  $('.parallaxie').parallaxie({
    speed: 0.5,
    offset: 0,
  });
  // Background Parallax - End
  // --------------------------------------------------

  // Videos & Images popup - Start
  // --------------------------------------------------
  $('.popup_video').magnificPopup({
    type: 'iframe',
    preloader: false,
    removalDelay: 160,
    mainClass: 'mfp-fade',
    fixedContentPos: false
  });

  $('.zoom-gallery').magnificPopup({
    delegate: '.popup_image',
    type: 'image',
    closeOnContentClick: false,
    closeBtnInside: false,
    mainClass: 'mfp-with-zoom mfp-img-mobile',
    gallery: {
      enabled: true
    },
    zoom: {
      enabled: true,
      duration: 300,
      opener: function(element) {
        return element.find('img');
      }
    }
    
  });
  // Videos & Images popup - End
  // --------------------------------------------------

  // Circle Progress Bar - Start
  // --------------------------------------------------
  function radial_animate() {
    $(".radial-progress").each(function (index, value) {
      $(this).find($(".bar--animated")).removeAttr("style");
      var elementTop = $(this).offset().top;
      var elementBottom = elementTop + $(this).outerHeight();
      var viewportTop = $(window).scrollTop();
      var viewportBottom = viewportTop + $(window).height();

      if (elementBottom > viewportTop && elementTop < viewportBottom) {
        var percent = $(value).data("countervalue");
        var radius = $(this).find($(".bar--animated")).attr("r");
        var circumference = 2 * Math.PI * radius;
        var strokeDashOffset = circumference - (percent * circumference) / 100;
        $(this)
        .find($(".bar--animated"))
        .animate({ "stroke-dashoffset": strokeDashOffset }, 1000);
      }
    });
  }
  var $window = $(window);
  function checkIfInView() {
    $(".countervalue").each(function () {
      if ($(this).hasClass("start")) {
        var elementTop = $(this).offset().top;
        var elementBottom = elementTop + $(this).outerHeight();

        var viewportTop = $(window).scrollTop();
        var viewportBottom = viewportTop + $(window).height();

        if (elementBottom > viewportTop && elementTop < viewportBottom) {
          $(this).removeClass("start");
          $(".countervalue").text();
          var myNumbers = $(this).text();
          if (myNumbers == Math.floor(myNumbers)) {
            $(this).animate(
            {
              Counter: $(this).text()
            },
            {
              duration: 1000,
              easing: "swing",
              step: function (now) {
                $(this).text(Math.ceil(now) + "%");
              }
            }
            );
          } else {
            $(this).animate(
            {
              Counter: $(this).text()
            },
            {
              duration: 1000,
              easing: "swing",
              step: function (now) {
                $(this).text(now.toFixed(2) + "$");
              }
            }
            );
          }

          radial_animate();
        }
      }
    });
  }
  $window.on("scroll", checkIfInView);
  $window.on("load", checkIfInView);
  // Circle Progress Bar - End
  // --------------------------------------------------

  // Slider, Carousels - Start
  // --------------------------------------------------
  // Home Page 1 Hero Slider
  const heroSliderOne = new Swiper('.hero_slider_1', {
    loop: true,
    speed: 1000,
    autoplay: {
      delay: 5000,
    },
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
      renderBullet: function (index, className) {
        return '<span class="' + className + '">' + (index + 1) + "</span>";
      },
    },
  });

  // Home Page 2 Hero Slider
  var heroSliderTwo = new Swiper(".hero_slider_2", {
    speed: 1000,
    parallax: true,
    autoplay: {
      delay: 5000,
    },
    navigation: {
      nextEl: ".swiper-button-hs2-next",
      prevEl: ".swiper-button-hs2-prev",
    },
    pagination: {
      el: ".swiper-pagination-hs2",
      clickable: true,
    },
  });

  // Home Page 3 Hero Slider
  const heroSliderThree = new Swiper('.hero_slider_3', {
    loop: true,
    speed: 1000,
    autoplay: {
      delay: 5000,
    },
    navigation: {
      nextEl: ".swiper-button-hs3-next",
      prevEl: ".swiper-button-hs3-prev",
    },
  });

  // 4 Column Slider
  var swiper3col = new Swiper(".carousel_3col", {
    loop: true,
    speed: 1000,
    slidesPerView: 3,
    spaceBetween: 30,
    navigation: {
      nextEl: ".swiper-button-3col-next",
      prevEl: ".swiper-button-3col-prev",
    },
    breakpoints: {
      0: {
        slidesPerView: 1,
      },
      640: {
        slidesPerView: 2,
      },
      992: {
        slidesPerView: 3,
      },
    },
  });

  // 5 Column Slider
  var swiper5col = new Swiper(".carousel_5col", {
    spaceBetween: 30,
    navigation: {
      nextEl: ".swiper-button-5col-next",
      prevEl: ".swiper-button-5col-prev",
    },
    scrollbar: {
      el: ".swiper-scrollbar",
      hide: false,
      draggable: true,
    },
    breakpoints: {
      640: {
        slidesPerView: 2,
      },
      1025: {
        slidesPerView: 3,
      },
      1461: {
        slidesPerView: 5,
      },
    },
  });

  // Testimonial Slider With Thumbnail
  var swiperThumbnailNav = new Swiper(".testimonial_carousel_nav", {
    loop: true,
    speed: 800,
    slidesPerView: 4,
    spaceBetween: 10,
    freeMode: true,
    watchSlidesProgress: true,
    breakpoints: {
      0: {
        slidesPerView: 2,
      },
      376: {
        slidesPerView: 3,
      },
      576: {
        slidesPerView: 4,
      },
    },
  });
  var swiperThumbnail = new Swiper(".testimonial_carousel", {
    loop: true,
    speed: 800,
    spaceBetween: 10,
    navigation: {
      nextEl: ".t-swiper-button-next",
      prevEl: ".t-swiper-button-prev",
    },
    thumbs: {
      swiper: swiperThumbnailNav,
    },
  });

  $('.howTo_carousel').owlCarousel({
    loop: true,
    margin: 20,
    // animateOut: 'fadeOut',
    // animateIn: 'fadeIn',
    nav: false,
    dots: true,
    center: true,
    autoplay: false,
    autoplaySpeed: 1000,
    autoplayTimeout: 5000,
    autoplayHoverPause: true,
    smartSpeed: 250,
    navText: [
      '<i class="far fa-chevron-left" aria-hidden="true"></i>',
      '<i class="far fa-chevron-right" aria-hidden="true"></i>'
    ],
    responsiveClass: true,
    responsive: {
      0: {
        items: 1
      },
      575: {
        items: 2
      },
      767: {
        items: 2
      },
      991: {
        items: 3
      },
      1199: {
        items: 3
      },
      1399: {
        items: 3
      }
    }
  });

  // Team Slider With Thumbnail
  var teamSwiperThumbnailNav = new Swiper(".team_carousel_nav", {
    loop: true,
    freeMode: false,
    spaceBetween: 0,
    slidesPerView: 3,
    slideToClickedSlide: true,
    centeredSlides: true,
    direction: "vertical",
    watchSlidesProgress: true,
  });
  var teamSwiperThumbnail = new Swiper(".team_carousel", {
    loop: true,
    speed: 800,
    effect: "fade",
    spaceBetween: 0,
    slidesPerView: 1,
    direction: "horizontal",
    navigation: {
      nextEl: ".team-swiper-button-next",
      prevEl: ".team-swiper-button-prev",
    },
  });
  teamSwiperThumbnail.controller.control = teamSwiperThumbnailNav;
  teamSwiperThumbnailNav.controller.control = teamSwiperThumbnail;

  // Partners Logo Carousel - Start
  var swiperPartnersLogo = new Swiper(".partners_logo_carousel", {
    loop: true,
    speed: 3000,
    spaceBetween: 10,
    slidesPerView: 4,      
    autoplay: {
      delay: 0,
      pauseOnMouseEnter: true,
    },
    breakpoints: {
      0: {
        slidesPerView: 2,
      },
      640: {
        slidesPerView: 3,
      },
      992: {
        slidesPerView: 4,
      },
    },
  });
  // Slider, Carousels - End
  // --------------------------------------------------

  // Service Collapse Items - Start
  // --------------------------------------------------
  $('.service_collapse_items > .title_wrap').first().addClass('active');
  $('.service_collapse_items .item_content').first().addClass('show');
  $('.service_collapse_items > .title_wrap').on('click', function () {
    $(this).addClass("active").siblings('.service_collapse_items > .title_wrap').removeClass('active');
    var $content = $(this).next('.item_content');
    $content.addClass('show').siblings('.service_collapse_items .item_content').removeClass('show');
  });
  // Service Collapse Items - End
  // --------------------------------------------------

  // Isotope Filter - Start
  // --------------------------------------------------
  var $grid = $(".grid").isotope({
    itemSelector: ".element-item",
    layoutMode: "fitRows"
  });

  var filterFns = {
    numberGreaterThan50: function () {
      var number = $(this).find(".number").text();
      return parseInt(number, 10) > 50;
    },
    ium: function () {
      var name = $(this).find(".name").text();
      return name.match(/ium$/);
    }
  };

  $(".filters-button-group").on("click", "button", function () {
    var filterValue = $(this).attr("data-filter");
    filterValue = filterFns[filterValue] || filterValue;
    $grid.isotope({ filter: filterValue });
  });

  $(".button-group").each(function (i, buttonGroup) {
    var $buttonGroup = $(buttonGroup);
    $buttonGroup.on("click", "button", function () {
      $buttonGroup.find(".is-checked").removeClass("is-checked");
      $(this).addClass("is-checked");
    });
  });
  // Isotope Filter - End
  // --------------------------------------------------


})(jQuery);