export function aboutDirectors() {
    if(!isMobile()) {
        const img = document.querySelectorAll("#dir-box figure")
        const titles = gsap.utils.toArray("#dir-box .names h2:not(.default)")
        let imgArea = document.querySelector(".thumbs")
        let split = new SplitText(titles, { type: "chars" })
        let splitDefault = new SplitText("#dir-box .names h2.default", { type: "chars" })
        gsap.set(split.chars, {
            yPercent: 100,
        })

        imgArea.addEventListener("mouseenter", function(){
            gsap.to(splitDefault.chars, {
                yPercent: -100,
                duration: .6,
                stagger: {
                    amount: .1,
                    from: "center"
                },
                ease: "power4"
            })
        })
        imgArea.addEventListener("mouseleave", function(){
            gsap.to(splitDefault.chars, {
                opacity: 1,
                yPercent: 0,
                stagger: {
                    amount: .1,
                    from: "center"
                },
                duration: .6,
                ease: "expo"
            })
        })


        img.forEach(i => {
            let thisData = i.dataset.img
            let item = document.querySelectorAll("[data-name= " + thisData + "] > div")
            let image = i.querySelector("img")

            i.addEventListener("mouseenter", function(){
                i.classList.add("hovered")
                gsap.to(image, {
                    filter: "grayscale(0)",
                    duration: .8,
                    ease: "power4"
                })
                gsap.to(item, {
                    yPercent: 0,
                    duration: .8,
                    stagger: {
                        amount: .1,
                        from: "center"
                    },
                    ease: "expo"
                })
            })

            i.addEventListener("mouseleave", function(){
                i.classList.remove("hovered")
                gsap.to(image, {
                    filter: "grayscale(1)",
                    duration: .8,
                    ease: "power4"
                })
                gsap.to(item, {
                    yPercent: 100,
                    duration: .8,
                    color: "#F93434",
                    stagger: {
                        amount: .1,
                        from: "center"
                    },
                    ease: "expo"
                }, "<")
            })

        })
    }
}
