// BIO ================================================================================================================================
// BIO ================================================================================================================================
// BIO ================================================================================================================================
export function bio() {

    let bioActive = function() {
        gsap.to("#bio", {
            pointerEvents: "auto",
            overflow: "visible"
        })
    }
    let bioOff = function() {
        gsap.to("#bio", {
            clearProps: "all",
            overflow: "hidden"
        })
    }

    // VARS ////////////////////////////////////////////////////////////////////////////////////
    let bgImg= document.querySelector("#bg-img"),
    firstName = document.querySelector("h1 .director-name"),
    firstNameIsSmall = firstName.classList.contains('f-180'),
    surname = document.querySelector("h1 .f-360 > div"),
    scrollTo = document.querySelector(".scroll-to"),
    profileImg = document.querySelector(".dir-img"),
    bioLink = document.querySelector(".bio-link"),
    bioContent = document.querySelector(".bio-content"),
    openBio = gsap.timeline({paused: true, ease: "power4", onReverseComplete: ()=> {
        if(!isMobile()) {
            smoother.paused(false)
        }
        bioOff()
    }}),

    // SET UP OUR FLIP CONTAINERS ////////////////////////////////////////////////////////////////
    // originalContainer = document.querySelector(".dir-img figure"),
    // newContainer = document.querySelector(".new-img"),
    surnameOffset = surname.getBoundingClientRect().left - (window.innerWidth / 24)

    gsap.set(bioContent, {
        yPercent: 10,
    })

    // CALCULATE NEW POSITION OF THE IMAGE //////////////////////////////////////////////


    if(!isMobile()) {
        // OPE NBIO ANIAMTION on DESKTOP ////////////////////////////////////////////////////////////////////////
        openBio.to(bgImg, {
            filter: "blur(20px)",
            duration: 1.5,
            scale: 1.2,
            transformOrigin: "center center",
            ease: "expo.inOut",
            onStart: () => {
                smoother.scrollTo("#hero",true, "top 0%")
            }
        })
        openBio.to(profileImg, {
            scale: .5,
            right: 0,
            x:0,
            rotate: 0,
            top: 0,
            y: firstNameIsSmall ? '-11%' : 0,
            duration: 1.5,
            ease: "expo.inOut"
        }, "<")
        openBio.to(scrollTo, {
            xPercent: -150,
            duration: 1.5,
            ease: "expo.inOut"
        }, "<")
        openBio.to(firstName, {
            transformOrigin: "top left",
            yPercent: firstNameIsSmall ? -20 : 0,
            scale: .4,
            duration: 1.5,
            ease: "expo.inOut"
        }, "<")
        openBio.to(surname, {
            transformOrigin: "top left",
            x: -surnameOffset,
            y: -(surname.offsetHeight / 10) * 4,
            scale: .47,
            duration: 1.5,
            ease: "expo.inOut"
        }, "-=1.4")
        openBio.to(bioLink, {
            transformOrigin: "center right ",
            duration: 1.5,
            y: "12vh",
            ease: "expo.inOut",
            onComplete: ()=> {
                gsap.to("#bio", {
                    zIndex: 10,
                    overflow: "auto"
                })
            }
        }, "<")
        openBio.to(bioContent, {
            opacity: 1,
            yPercent: 0,
            duration: 1,
            ease: "expo",
        }, "-=.7")
        openBio.to(".read-bio", {
            opacity: 0,
            y: "-1em",
            duration: .75,
            ease: "expo.inOut",
        }, "-=1.4")
        openBio.to(".close-bio", {
            opacity:1,
            y: 0,
            duration: .75,
            ease: "expo.inOut",
        }, "<")
    } else {
        openBio.to(scrollTo, {
            yPercent: 150,
            delay: .2,
            duration: 1.5,
            ease: "expo.inOut"
        })
        openBio.to(profileImg, {
            scale: .37,
            right: 0,
            x:0,
            rotate: 0,
            top: "60%",
            y: 0,
            duration: 1.5,
            ease: "expo.inOut"
        }, "<")
        openBio.to(firstName, {
            transformOrigin: "top left",
            xPercent: -100,
            duration: 1.5,
            ease: "expo.inOut"
        }, "<")
        openBio.to(surname, {
            transformOrigin: "top right",
            x: (window.innerWidth / 2) + (surname.offsetWidth / 2),
            duration: 1.5,
            ease: "expo.inOut"
        }, "-=1.4")
        openBio.to(bioLink, {
            transformOrigin: "bottom right ",
            yPercent: 250,
            xPercent: -100,
            left: "100%",
            duration: 1.5,
            ease: "expo.inOut",
            onComplete: ()=> {
                gsap.to("#bio", {
                    // zIndex: 10,
                    overflow: "auto"
                })
            }
        }, "<")
        openBio.to(bioContent, {
            opacity: 1,
            yPercent: 0,
            duration: 1.5,
            ease: "expo.inOut",
        }, "-=1.4")
        openBio.to(".read-bio", {
            opacity: 0,
            y: "-1em",
            duration: .75,
            ease: "expo.inOut",
        }, "-=1.4")
        openBio.to(".close-bio", {
            opacity:1,
            y: 0,
            duration: .75,
            ease: "expo.inOut",
        }, "<")
    }



    // EVENT LISTENERS /////////////////////////////////////////////////////////////////////////////////////////////////
    bioLink.addEventListener("click", function(){
        if(!isMobile()) {
            smoother.paused(true)
        }

        if(!bioLink.classList.contains("clicked") && !openBio.isActive()) {
            if(isMobile()) {
                gsap.to(window, {duration: .35, ease: "power3", scrollTo: "#hero"});
                bodyTag.style.overflow = "hidden"
                bodyTag.style.height = "100vh"
            }
            
            bioLink.classList.add("clicked")
            bioActive()
            openBio.play()
        } else if (bioLink.classList.contains("clicked") && !openBio.isActive())  {
            if(isMobile()) {
                bodyTag.style.overflow = "auto"
                bodyTag.style.height = "auto"
            }
            bioLink.classList.remove("clicked")

            // const state = Flip.getState(profileImg);
            // (profileImg.parentNode === newContainer ? originalContainer : newContainer).appendChild(profileImg)
            // Flip.from(state, {duration: 1.5, ease: customEase })

            openBio.reverse()
        }
    })

}

// WORK ================================================================================================================================
// WORK ================================================================================================================================
// WORK ================================================================================================================================
export function work() {

    let items = document.querySelectorAll("#work li"),
        closeVid = document.querySelector(".video-close"),
        vidSrc,
        vidModal = gsap.timeline(),
        ul = document.querySelector("#work ul")

        let thisWidth

        if(!isMobile() && window.innerWidth > 1024) {
            thisWidth = (window.innerWidth / 24) * 9 + "px"
            
        } else {
            thisWidth = (window.innerWidth / 24) * 11 + "px"
        }
        console.log(thisWidth)

    ////// HOVERING ITEMS ///////////////////////////////////////////////////////////////////////////////////////////////////
    items.forEach(item => {
        let project = item.querySelector("h2 > span:first-of-type"),
        projectHover = item.querySelector("h2 .title-hover"),
        line = item.querySelector("hr"),
        mainSplit = new SplitText(project, { type: "lines, chars" }),
        hoverSplit = new SplitText(projectHover, { type: "lines, chars" }),
        play = item.querySelector("i"),
        itemHeight = 0

        if(!isMobile()) {
            itemHeight = item.offsetHeight * 2
        } else {
            itemHeight = item.offsetHeight * 3
        }

        let hoverArea = item.querySelectorAll(".vid-hover")

        let itemImage = item.querySelector("figure")

        gsap.set(item, {
            height: item.offsetHeight
        })
        gsap.set(itemImage, {flexBasis: window.innerWidth / 12 + "px"})
        gsap.set(line, {scaleX: 0})
        // gsap.set(item, {scale: .7})
        gsap.set(hoverSplit.chars, {
            transformOrigin: "left bottom",
            yPercent: 0,
            scaleY: 0,
        })

        // SET UP SCROLL TRIGGER ITEMS
        let scrollIn = gsap.timeline({
            scrollTrigger: {
                trigger: item,
                start: "top 110%",
                end: () => "+=" + itemHeight,
                scrub: true,
                // markers: true
            }
        })
        scrollIn.to(itemImage, {
            flexBasis: thisWidth
        })
        gsap.to(line, {
            scrollTrigger: {
                trigger: item,
                start: "bottom bottom",
                end: () => "+=" + item.offsetHeight * 1.3,
                scrub: true
            },
            scaleX: 1,
        })


        // HOVE ANIMATION
        hoverArea.forEach(hi => {
            hi.addEventListener("mouseenter", function() {
                item.classList.add("active")

                gsap.to(mainSplit.chars, {
                    transformOrigin: "top left",
                    yPercent: -10,
                    scaleY: 0,
                    stagger: {
                        amount: .1
                    },
                    ease: "power4",
                    duration: .6
                })
                gsap.to(hoverSplit.chars, {
                    yPercent: 4,
                    scaleY: 1,
                    stagger: {
                        amount: .1
                    },
                    ease: "power4",
                    duration: .6
                })
                gsap.to(play, {
                    scale: 1,
                    duration: .6,
                    ease: "power4",
                })

            })
            hi.addEventListener("mouseleave", function() {
                item.classList.remove("active")

                gsap.to(mainSplit.chars, {
                    transformOrigin: "top left",
                    yPercent: 0,
                    scaleY: 1,
                    stagger: {
                        amount: .1
                    },
                    ease: "power4",
                    duration: .6
                })
                gsap.to(hoverSplit.chars, {
                    yPercent: -10,
                    scaleY: 0,
                    stagger: {
                        amount: .1
                    },
                    ease: "power4",
                    duration: .6
                })
                gsap.to(play, {
                    scale:0,
                    duration: .6,
                    ease: "power4",
                })
            })

            // OPEN VIDEO MODAL
            hi.addEventListener("click", function() {
                if(!isMobile()) {
                    smoother.paused(true)
                }
                let thisData = item.dataset.project,
                thisVideo = document.querySelector("[data-video= " + thisData + "]"),
                thisBrand = thisVideo.querySelector("h2"),
                thisProject = thisVideo.querySelector("p"),
                thisFrame = thisVideo.querySelector("iframe")
                vidSrc = thisFrame.src

                closeVid.dataset.open = thisData;

                vidModal.to(".video-bg", {
                    scaleY: 1,
                    duration: 1,
                    ease: customEase,
                    onStart: ()=> {
                        gsap.to("#video-wrap", {
                            pointerEvents: "auto",
                        })
                        gsap.set(thisVideo, {zIndex: 2})
                    }
                })
                vidModal.to(["#logo" , "#nav-bg", "#hamburger"], {
                    opacity: 0,
                    duration: .5,
                    ease: "power4",
                    pointerEvents: "none",
                    onStart: () => {
                        gsap.to(thisFrame, {
                            display: "block",
                        })
                    }
                }, "<")
                vidModal.to(thisFrame, {
                    opacity: 1,
                    y: "12.5vh",
                    duration: 1.2,
                    ease: "expo"
                },"-=.5")
                vidModal.to(closeVid, {
                    opacity: 1,
                    y: 0,
                    duration: 1.2,
                    ease: "expo",
                }, "-=.85")
                vidModal.to([thisBrand, thisProject], {
                    opacity: 1,
                    y: 0,
                    duration: 1.,
                    ease: "expo"
                },"-=1")

                item.classList.add("active")
                return vidSrc
            })
        })
        
    })

    closeVid.addEventListener("click", function() {
        let thisData = closeVid.dataset.open,
        thisVideo = document.querySelector("[data-video= " + thisData + "]"),
        thisBrand = thisVideo.querySelector("h2"),
        thisProject = thisVideo.querySelector("p"),
        thisFrame = thisVideo.querySelector("iframe")

        // console.log(vidSrc)

        vidModal.to(closeVid, {
            opacity: 0,
            duration: 1,
            y: "-100%",
            ease: customEase,
        })
        vidModal.to(thisFrame, {
            opacity: 0,
            y: "-20%",
            duration: 1,
            ease: customEase,
            onComplete: () => {
                gsap.to(thisFrame, {
                    display: "none"
                })
                thisFrame.src = thisFrame.src
            }
        },"<")
        vidModal.to([thisBrand, thisProject], {
            opacity: 0,
            y: "50%",
            duration: 1,
            ease: customEase
        },"<")
        vidModal.to(".video-bg", {
            scaleY: 0,
            duration: 1,
            ease: "expo",
            onComplete: ()=> {
                gsap.to("#video-wrap", {
                    pointerEvents: "none",
                })
                gsap.set(thisVideo, {zIndex: "auto"})
            }
        },"-=.5")
        vidModal.to(["#logo" , "#nav-bg", "#hamburger"], {
            opacity: 1,
            duration: .5,
            ease: "power4",
            pointerEvents: "auto",
            onStart: ()=> {
                if(!isMobile()) {
                    smoother.paused(false)
                }
                delete  closeVid.dataset.open
            }
        }, ">")
    })


    // MAKE SPLIT ACTIVE
    let splitTitle = new SplitText(".link-wrap span:first-of-type", { type: "chars" })
    let splitTitleHover = new SplitText(".link-wrap span:nth-of-type(2)", { type: "chars" })
    gsap.set(splitTitle.chars, {transformOrigin: "0% 100%"})
    gsap.set(splitTitleHover.chars, {transformOrigin: "bottom left", scaleY: 0, y: "20%"})
    

}

export function thumbnails() {
    if(!isMobile() && window.innerWidth > 1024) {
        let imgs = gsap.utils.toArray(".mouse-react")
        
        // })
        // DRAG FOLLOW
        let mouseX = 0
        let mouseY = 0
        let ballX = 0
        let ballY = 0
        let ballSpeed = .015

        function imgMove() {
            let distX = mouseX - ballX
            let distY = mouseY - ballY

            ballX = Math.round(ballX + (distX * ballSpeed))
            ballY = Math.round(ballY + (distY * ballSpeed))

            let xHalf = ballX - window.innerWidth / 2;
            let yHalf = ballY - window.innerHeight / 2;

            let xPerc = Math.round(100 / window.innerWidth * xHalf)
            let yPerc = Math.round(100 / window.innerHeight * yHalf)

            gsap.to(imgs, {
                rotateX: yPerc / 30,
                rotateY: xPerc / 30,
                xPercent: xPerc / 15,
                // yPercent: yPerc / 7,
                stagger: {
                    each: .01
                },
                duration: .0001,
                ease: "linear"
            })


            requestAnimationFrame(imgMove)
        }

        imgMove()


        document.addEventListener("mousemove", function(event) {
            mouseX = event.clientX
            mouseY = event.clientY
            
        })  
    }
}
