export function directorsHover() {
    if(!isMobile() && window.innerWidth > 1024) {
        let links = document.querySelectorAll(".directors li a")
        let listingWrap = document.querySelector(".dir-listing ul")
        let timeout = 600

        // END VIDEO LOAD ///////////////////////////////////////////////////////////////////

        // MAKE VIDEO DISAPPEAR / APPEAR

        let trackTl = gsap.timeline({repeat: -1, yoyo: true, paused: true, repeatDelay: .25})
        trackTl.to("#track i", {
            opacity: 0,
            duration: .1,
            ease: "linear"
        })
        setTimeout(function() {
            listingWrap.addEventListener("mouseenter", function() {
                gsap.to("#track i", {
                    scale: 2,
                    duration: .4,
                    ease: "power3"
                })
                gsap.to(".dir-title h1 div div", {
                    yPercent:60,
                    stagger: {
                        amount: .1
                    },
                    transformOrigin: "top left",
                    duration: .6,
                    ease: "power3"
                })
            })
            listingWrap.addEventListener("mouseleave", function() {
                gsap.to("#track i", {
                    scale: 1,
                    duration: .4,
                    ease: "power3",
                })
                gsap.to(".dir-title h1 div div", {
                    yPercent: 0,
                    stagger: {
                        amount: .1
                    },
                    transformOrigin: "top left",
                    duration: .6,
                    ease: "power3"
                })
                trackTl.pause().progress(0)


            })
        }, timeout)


        let thisImage
        links.forEach(li => {
            let project = li.querySelectorAll("h2 a > span:first-of-type div div"),
            projectHover = li.querySelector("h2 .title-hover"),
            hoverSplit = new SplitText(projectHover, { type: "chars" })

            gsap.set(hoverSplit.chars, {
                transformOrigin: "left bottom",
                scaleY: 0,
            })

            setTimeout(function(){
                li.addEventListener("mouseenter", function() {
                    let thisData = li.dataset.target
                    gsap.to(".directors li a", {opacity: .2, duration: .4, ease: "power4"})
                    // ADD CLASS TO OUR IMAGE
                    li.classList.add("active")
                    thisImage = document.querySelector('[data-page="' + thisData + '"]')
                    gsap.set(thisImage, {
                        "-webkit-filter": "blur(15px)",
                    })
                    gsap.to(thisImage, {
                        opacity: .75,
                        duration: .4,
                        "-webkit-filter": "blur(0px)",
                        ease: "power2"
                    })
                    gsap.to(project, {
                        transformOrigin: "top left",
                        yPercent: -35,
                        scaleY: 0,
                        stagger: {
                            amount: .1
                        },
                        ease: "expo",
                        duration: .5
                    })
                    gsap.to(hoverSplit.chars, {
                        yPercent: 0,
                        scaleY: 1,
                        stagger: {
                            amount: .1
                        },
                        ease: "expo",
                        duration: .5
                    })
                })
                li.addEventListener("mouseleave", function() {
                    let thisData = li.dataset.target
                    gsap.to(".directors li a", {opacity: 1, duration: .4, ease: "power4"})
                    li.classList.remove("active")
                    thisImage = document.querySelector('[data-page="' + thisData + '"]')

                    gsap.to(thisImage, {
                        opacity: 0,
                        duration: .4,
                        "-webkit-filter": "blur(15px)",
                        ease: "power2"
                    })

                    gsap.to(project, {
                        transformOrigin: "top left",
                        yPercent: 0,
                        scaleY: 1,
                        stagger: {
                            amount: .1
                        },
                        ease: "expo",
                        duration: .5
                    })
                    gsap.to(hoverSplit.chars, {
                        yPercent: 10,
                        scaleY: 0,
                        stagger: {
                            amount: .1
                        },
                        ease: "expo",
                        duration: .5
                    })
                })
            }, timeout)
        })
    }

}

export function dirMobile() {
    if(isMobile() && window.innerWidth < 1024) {
        let items = gsap.utils.toArray(".dir-listing li")
        items.forEach(i => {
            let img = i.querySelector("a > div")
            let title = i.querySelector("span")
            gsap.set(img, {width: 10})
            gsap.set(i, {width: "50%"})
            gsap.set(title, {x: -window.innerWidth / 7, scale: .7, transformOrigin: "center left"})

            let tl = gsap.timeline({
                scrollTrigger: {
                    trigger: i,
                    start: "bottom bottom",
                    end: "bottom 60%",
                    scrub: true
                }
            })

            tl.to(img, {
                width: (window.innerWidth / 24) * 7,
                duration: 1,
                ease: "power1"
            })
            tl.to(i, {
                width: "100%",
                duration: 1,
                ease: "power1"
            }, "<")
            tl.to(title, {
                x: 0,
                duration: 1,
                scale: 1,
                ease: "power1"
            }, "<")
        })

    }
}

export function dotMove() {
    if(!isMobile() && window.innerWidth > 1024) {
        let ball = document.querySelector("#track")
        let listingWrap = document.querySelector(".dir-listing")


        const ballDimensions =  ball.getBoundingClientRect();
        const dimensions = listingWrap.getBoundingClientRect();
        const setY = gsap.quickSetter(ball, "y", "px");
        const clamperY = gsap.utils.clamp(
            (0),
            (dimensions.height - ballDimensions.height),
        );

        // DRAG FOLLOW
        let mouseX = 0
        let mouseY = 0

        document.addEventListener("mousemove", function(event) {
            mouseX = event.pageX
            mouseY = event.pageY
            setY(clamperY(event.pageY - ballDimensions.top * 1.6));
        })
    }
}
