export function heroAnim() {

    // VARS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    let heroImg = gsap.utils.toArray(".hero-img"),
    heroEl = gsap.utils.toArray(".hero-in")

    gsap.set(heroEl, {opacity: 0})
    gsap.set(heroImg, {rotate: -15, scale: .8})


    // LETTER ANIMATION SETUP =======================================================================================
    let heroChars = new SplitText(".hero-split.chars", { type: "lines, chars" })
    let heroSide = new SplitText(".hero-split.bottom", { type: "lines, chars" })
    let heroLines = new SplitText(".hero-split.lines", { type: "lines" })
    gsap.set(heroChars.chars, {
        transformOrigin: "top left",
        y: "-30%",
        scaleY: 0,
    })
    gsap.set(heroSide.chars, {
        transformOrigin: "bottom right",
        x: window.innerWidth,
    })
    gsap.set(heroLines.lines, {
        opacity: 0,
        y: "150%"
    })

    let tl = gsap.timeline()

    // DIRECTOR DETAIL =======================================================================================
    if(document.querySelector(".director-detail")) {
        gsap.set(".bio-link", {
            pointerEvents: "none",
        })


        // IMG SCROLL ROTATION WILL BE PASSED AFTER INTRO ///////////////////////////////////////////////////////
        function scrollRotate() {
            let scrollAnim = gsap.timeline({
                scrollTrigger:{
                    trigger: "#hero",
                    start: "top top",
                    end: "bottom top",
                    scrub: true,
                }
            })
            scrollAnim.to(".dir-img figure", {
                rotate: 10,
                yPercent: 35,
                ease: "linear"
            })
        }

        // HERO TEIMLINE DESKTOP /////////////////////////////////////////////////////////////////////////////
        if(!isMobile()) {
            smoother.paused(true)
            smoother.effects("#bg-img img", { speed: ".85" })
            tl.to(heroChars.chars, {
                duration: 1.5,
                stagger: {
                    amount: .2
                },
                scaleY: 1,
                y: 0,
                ease: customEase
            })
            tl.to(heroImg, {rotate: -7, y: "-50%", scale: 1, duration: 1, ease: "power4"}, "-=.8")
            tl.to(heroEl, {opacity: 1, scale: 1, duration: .75, stagger: {amount: .2}, ease: "power4", onStart: ()=> {
                gsap.set(".bio-link", {
                    delay: .5,
                    pointerEvents: "auto",
                })
                }, 
                onComplete: () => {
                    scrollRotate()
                    smoother.paused(false)
                }
            }, "-=1")
        } else {
            tl.to(heroChars.chars, {
                duration: 1.5,
                stagger: {
                    amount: .2
                },
                scaleY: 1,
                y: 0,
                ease: customEase
            })
            tl.to(heroImg, {rotate: 0, y: heroImg[0].classList.contains('long-name') ? "-8%" : "0%", scale: 1, duration: 1.5, ease: customEase}, "-=1.4")

            tl.to(heroEl, {opacity: 1, scale: 1, duration: 1.5, stagger: {amount: .2}, ease: "power4", onStart: ()=> {
                gsap.set(".bio-link", {
                    pointerEvents: "auto",
                })
            }}, "-=.5")
        }


    }

    // DIRECTORS PAGE =======================================================================================
    if(document.querySelector(".directors")) {
        tl.to(heroSide.chars, {
            duration: 1,
            stagger: {
                amount: .2
            },
            x: 0,
            ease: "power4",
        })
        tl.to(heroChars.chars, {
            duration: 1,
            stagger: {
                amount: .2
            },
            scaleY: 1,
            y: 0,
            ease: "power4",
        }, "-=.7")
        tl.to(heroEl, {
            opacity: 1,
            duration: 1,
            ease: "power4",
        }, "-=.9")

        if(window.innerWidth < 1024) {
            let list = gsap.utils.toArray(".dir-listing li")
            gsap.set(list, {opacity: 0, yPercent: 50})
            gsap.to(list, {
                yPercent: 0,
                opacity: 1,
                duration: .8,
                stagger: {
                    each: .05
                },
                ease: "power3.inOut"
            })
        }
    }

    // ABOUT PAGE =======================================================================================
    if(document.querySelector(".about")) {
        if(!isMobile) {
            smoother.paused(true)
        }
        gsap.set("#hero", {
            transformOrigin: "center left",
            yPercent: -10,
            rotate: -10
        })
        gsap.set("#hero h1 span svg path", {
            transformOrigin: "top left",
            opacity: 0,
            scaleY: 0,
        })
        tl.to("#hero", {
            duration: 1,
            rotate: 0,
            yPercent: 0,
            ease: customEase,
        })
        tl.to(heroChars.chars, {
            duration: 1,
            stagger: {
                amount: .2
            },
            scaleY: 1,
            y: 0,
            ease: customEase
        },"<")
        tl.to("#hero h1 span svg path", {
            opacity: 1,
            duration: .8,
            stagger: {
                amount: .2
            },
            scaleY: 1,
            ease: customEase
        },"-=.7")
        tl.to(heroLines.lines, {
            opacity: 1,
            duration: 1,
            y: 0,
            stagger: 0.03,
            ease: "expo.out"
        }, "-=.5")
        tl.to(heroEl, {
            opacity: 1,
            duration: 1,
            ease: "expo.out",
            onStart: () => {
                if(!isMobile) {
                    smoother.paused(false)
                }
            }
        }, "<")
    }

    // PRESS PAGE =======================================================================================
    if(document.querySelector(".press")) {
        if(!isMobile) {
            smoother.paused(true)
        }
        gsap.set("#hero", {
            transformOrigin: "center left",
            yPercent: -10,
            rotate: -10
        })
        tl.to("#hero", {
            duration: 1,
            rotate: 0,
            y: 0,
            ease: customEase
        })
        tl.to(heroChars.chars, {
            duration: 1,
            stagger: {
                amount: .2
            },
            scaleY: 1,
            y: 0,
            ease: customEase,
            onComplete: () => {
                if(!isMobile) {
                    smoother.paused(false)
                }
            }
        },  "<")
        tl.to(".press .first", {
            duration: 1,
            y: 0,
            opacity: 1,
            ease: "power4",
        }, "-=.5")
    }

    // CONTACT PAGE =======================================================================================
    if(document.querySelector(".contact")) {
        if(!isMobile) {
            smoother.paused(true)
        }
        tl.to(heroChars.chars, {
            duration: 1,
            stagger: {
                amount: .2
            },
            scaleY: 1,
            y: 0,
            ease: customEase
        })
        tl.to(heroLines.lines, {
            opacity: 1,
            duration: 1,
            y: 0,
            stagger: 0.03,
            ease: "expo.out"
        }, "-=.5")
        tl.to(heroEl, {
            opacity: 1,
            duration: 1,
            ease: "power4",
            onStart: () => {
                if(!isMobile) {
                    smoother.paused(false)
                }
            }
        }, "<")
    }

}
