export function linkHover() {

	// HOME ARROW BUTTON LINK;
	if(document.querySelector(".dir-link-btn") && !isMobile() && window.innerWidth > 1024) {
		let linkArrow = document.querySelector(".link-button")
		let homeLink = document.querySelector(".dir-link-btn")
		let curTitle = gsap.utils.toArray(".link-wrap span:first-of-type div")
		let newTitle = gsap.utils.toArray(".link-wrap span:nth-of-type(2) div")
		let click = false


		let linkArrowLottie = lottie.loadAnimation({
			container: linkArrow, // the dom element that will contain the animation
			renderer: 'svg',
			loop: false,
			autoplay: false,
			path: 'js/lottie/arrow.json',
			rendererSettings: {
				preserveAspectRatio: 'xMidYMid', // Supports the same options as the svg element's preserveAspectRatio property
				progressiveLoad: false, // Boolean, only svg renderer, loads dom elements when needed. Might speed up initialization for large number of elements.
				hideOnTransparent: true, //Boolean, only svg renderer, hides elements when opacity reaches 0 (defaults to true)
				className: ''
			}
		});
		linkArrowLottie.stop()
		const aiBg = linkArrow.querySelector("i")
		let tl = gsap.timeline({paused: true})
		tl.to(aiBg, {
			scale: 1.1,
			duration: .8,
			ease: "power3.inOut"
		})
		tl.to(curTitle, {
			transformOrigin: "top left",
			scaleY: 0.1,
			y: "-20%",
			stagger: {
				amount: .1
			},
			duration: .8,
			ease: "power3.inOut"
		}, "<")
		tl.to(newTitle, {
			transformOrigin: "bottom left",
			scaleY: 1,
			y: "0%",
			stagger: {
				amount: .1
			},
			duration: .8,
			ease: "power3.inOut"
		}, "<")
		homeLink.addEventListener("click", function() {
			click = true
			return click
		})

		homeLink.addEventListener("mouseenter", function() {
			linkArrowLottie.setDirection(1);
			linkArrowLottie.setSpeed(.75)
			linkArrowLottie.play()
			// linkArrowLottie.addEventListener("complete", reverse)
			tl.play().timeScale(1)
		})
		homeLink.addEventListener("mouseleave", function() {
			if(click === false) {
				linkArrowLottie.setDirection(-1);
				linkArrowLottie.setSpeed(1.5)
				linkArrowLottie.play()
				tl.reverse().timeScale(-1)
			} else if(click === true) {
				
			}

		})
	}


}

export function bgMove() {

	let rows = gsap.utils.toArray("#bgThumbs ul")
	let cards = gsap.utils.toArray("#bgThumbs li")
	let rowItems = gsap.utils.toArray("#bgThumbs li .row-item")
	let xOffset = (((cards.length / 3) * cards[0].offsetWidth) - window.innerWidth) / 2

	if(!isMobile() && window.innerWidth > 1024) {
		
		gsap.set(rows, {
			x: -xOffset
		})
		
		// })
		// DRAG FOLLOW
		let mouseX = 0
		let mouseY = 0
		let ballX = 0
		let ballY = 0
		let ballSpeed = .015

		function cursorMove() {
			let distX = mouseX - ballX
			let distY = mouseY - ballY

			ballX = Math.round(ballX + (distX * ballSpeed))
			ballY = Math.round(ballY + (distY * ballSpeed))

			let xHalf = ballX - window.innerWidth / 2;
			let yHalf = ballY - window.innerHeight / 2;

			let xPerc = Math.round(100 / window.innerWidth * xHalf)
			let yPerc = Math.round(100 / window.innerHeight * yHalf)

			// animate rows independently
			let row1 = document.querySelector("#bgThumbs ul:first-of-type")
			let row2 = document.querySelector("#bgThumbs ul:nth-of-type(2)")
			let row3 = document.querySelector("#bgThumbs ul:nth-of-type(3)")

			gsap.to(rowItems, {
				rotateX: yPerc / 20,
				rotateY: xPerc / 20,
				xPercent: xPerc / 8,
				// yPercent: yPerc / 7,
				stagger: {
					each: .01
				},
				duration: .0001,
				ease: "linear"
			})

			gsap.to(row1, {
				x: -xOffset + xPerc * 1.3 ,
			})
			gsap.to(row2, {
				x: -xOffset + xPerc / 1.5,
			})
			gsap.to(row3, {
				x: -xOffset + xPerc,
			})

			requestAnimationFrame(cursorMove)
		}

		cursorMove()


		document.addEventListener("mousemove", function(event) {
			mouseX = event.pageX
			mouseY = event.pageY
			
		})  
	}

}