export function lazyLoad() {
  
  if (document.querySelector(".lazy")) {
      ScrollTrigger.config({ limitCallbacks: true });
      gsap.utils.toArray(".lazy").forEach(image => {
        
        let newSRC = image.dataset.src,
            newImage = document.createElement("img"),
            
        loadImage = () => {
          newImage.onload = () => {
            newImage.onload = null; // avoid recursion
            newImage.src = image.src; // swap the src
            image.src = newSRC;
            // place the low-res version on TOP and then fade it out.
            gsap.set(newImage, {
              position: "absolute", 
              top: image.offsetTop, 
              left: image.offsetLeft, 
              width: image.offsetWidth, 
              height: image.offsetHeight
            });
            image.parentNode.appendChild(newImage);
            gsap.to(newImage, {
              opacity: 0, 
              duration: .35,
              onComplete: () => newImage.parentNode.removeChild(newImage)
            });
            st && st.kill();
          }
          newImage.src = newSRC;
        }, 
            
        st = ScrollTrigger.create({
          trigger: image,
          start: "top 150%",
          onEnter: loadImage,
          onEnterBack: loadImage // make sure it works in either direction
        });
      });
    }

  }

  