export function menu(){

    // CREATE HAMBURGER LOTTIE ///////////////////////////////////////////////////////
    const icon =document.querySelector("#hamburger i")
    let hambLottie
    if(!isMobile()) {
        hambLottie = lottie.loadAnimation({
            container: icon, // the dom element that will contain the animation
            renderer: 'svg',
            loop: false,
            autoplay: false,
            path: 'js/lottie/hamburger-2.json',
            rendererSettings: {
                preserveAspectRatio: 'none', // Supports the same options as the svg element's preserveAspectRatio property
                progressiveLoad: false, // Boolean, only svg renderer, loads dom elements when needed. Might speed up initialization for large number of elements.
                hideOnTransparent: true, //Boolean, only svg renderer, hides elements when opacity reaches 0 (defaults to true)
                className: ''
            }
        });
    } else {
        hambLottie = lottie.loadAnimation({
            container: icon, // the dom element that will contain the animation
            renderer: 'svg',
            loop: false,
            autoplay: false,
            path: 'js/lottie/hamburger-mobile.json',
            rendererSettings: {
                preserveAspectRatio: 'none', // Supports the same options as the svg element's preserveAspectRatio property
                progressiveLoad: false, // Boolean, only svg renderer, loads dom elements when needed. Might speed up initialization for large number of elements.
                hideOnTransparent: true, //Boolean, only svg renderer, hides elements when opacity reaches 0 (defaults to true)
                className: ''
            }
        });
    }

    hambLottie.stop()

    const navBg = document.querySelector("#nav-bg")
    const hamburger = document.querySelector("#hamburger")
    const hambLabel = document.querySelector("#hamburger span span")
    const navigation = document.querySelector("#navigation")
    const pageOverlay = document.querySelector("#pageOverlay")
    const plusIcon = document.querySelector("#navigation .plus")
    const links = gsap.utils.toArray("#navigation a")

    gsap.set(links, {yPercent: 30, opacity: 0})

    if(window.innerWidth > 1024 && !isMobile()) {
        // GET NAV DIMENSIONS
        const navBoxHeight = navigation.offsetHeight
        const navBoxWidth = navigation.offsetWidth

        let tl = gsap.timeline({paused: true})
        tl.to(pageOverlay, {
            opacity: .6,
            pointerEvents: "auto",
            duration: 1,
            ease: customEase
        })
        tl.to(icon, {
            scale: 1.3,
            duration: 1,
            ease: customEase
        }, "<")
        tl.to(navBg, {
            width: navBoxWidth,
            height: navBoxHeight,
            top: 0,
            right: 0,
            borderRadius: 0,
            duration: 1,
            ease: customEase
        }, "<")
        tl.to(links, {
            yPercent: 0,
            opacity: 1,
            duration: .35,
            stagger: {
                amount: .1,
                from: "start"
            },
            onStart: ()=> {
                gsap.set(plusIcon, {opacity: 0, rotateZ: -90})
                gsap.to(plusIcon, {
                    opacity: 1,
                    rotateZ: 0,
                    duration: .6,
                    ease: "power3"
                })
            },
            ease: customEase
        }, "-=.45")

       
        hamburger.addEventListener("mouseenter", function() {
            hamburger.classList.add("opened")
            tl.restart().timeScale(1)
            hambLottie.setDirection(1);
            hambLottie.setSpeed(1)
            hambLottie.play()
            navigation.style.pointerEvents = "auto"
        })
        navigation.addEventListener("mouseleave", function() {
            hamburger.classList.remove("opened")
            tl.reverse().timeScale(-2)
            hambLottie.setDirection(-1);
            hambLottie.setSpeed(1.5)
            hambLottie.play()
            navigation.style.pointerEvents = "none"

            gsap.to(plusIcon, {
                opacity: 0,
                rotateZ: -90,
                duration: .6,
                ease: "power3"
            })
        })

        links.forEach(link => {
            let splitCur = new SplitText(link.querySelector("a span:first-of-type"), { type: "chars" })
            let splitNew = new SplitText(link.querySelector("a span:nth-of-type(2)"), { type: "chars" })
            gsap.set(splitCur.chars, {transformOrigin: "top right"})
            gsap.set(splitNew.chars, {scaleY:.1, yPercent: 20, transformOrigin: "bottom left"})
            let thisID = link.dataset.pos
            link.addEventListener("mouseenter", function() {

                gsap.to(plusIcon, {
                    rotateZ: 90 * thisID,
                    duration: .8,
                    ease: "power3"
                })
                gsap.to(splitCur.chars, {
                    scaleY: .1,
                    yPercent: -25,
                    duration: .4,
                    stagger: {
                        amount: .15,
                        from: "end"
                    },
                    ease: "power3"
                })
                gsap.to(splitNew.chars, {
                    scaleY: 1,
                    yPercent: 0,
                    duration: .4,
                    stagger: {
                        amount: .15,
                        from: "end"
                    },
                    ease: "power3"
                })
            })
            link.addEventListener("mouseleave", function() {
                gsap.to(plusIcon, {
                    rotateZ: 0,
                    duration: .8,
                    ease: "power3"
                })
                gsap.to(splitCur.chars, {
                    scaleY: 1,
                    yPercent: 0,
                    duration: .4,
                    stagger: {
                        amount: .15,
                        from: "end"
                    },
                    ease: "power3"
                })
                gsap.to(splitNew.chars, {
                    scaleY:.1,
                    yPercent: 20,
                    duration: .4,
                    stagger: {
                        amount: .15,
                        from: "end"
                    },
                    ease: "power3"
                })
            })

            link.addEventListener("click", function() {
                hamburger.classList.remove("opened")
                tl.reverse().timeScale(-2)
                hambLottie.setDirection(-1);
                hambLottie.setSpeed(1)
                hambLottie.play()
                navigation.style.pointerEvents = "none"

            })
        })

    } else if(isMobile() || window.innerWidth < 1024) {
        const navBoxHeight = navigation.offsetHeight

        let tl = gsap.timeline({paused: true})
        tl.to(pageOverlay, {
            opacity: .6,
            pointerEvents: "auto",
            duration: 1,
            ease: customEase
        })
        tl.to("#logo", {
            yPercent: 20,
            duration: 1,
            ease: customEase
        }, "<")
        tl.to(navBg, {
            width: window.innerWidth,
            height: navBoxHeight,
            top: 0,
            right: 0,
            borderRadius: 0,
            duration: 1,
            ease: customEase
        }, "<")
        tl.to(hambLabel, {y: "0%", duration: 1, ease: customEase}, "<")
        tl.to(links, {
            yPercent: 0,
            opacity: 1,
            duration: .35,
            stagger: {
                amount: .1,
                from: "start"
            },
            ease: customEase
        }, "-=.3")

        hamburger.addEventListener("click", function() {
            if(!hamburger.classList.contains("opened")) {
                hamburger.classList.add("opened")
                tl.restart().timeScale(1)
                hambLottie.setDirection(1);
                hambLottie.setSpeed(1)
                hambLottie.play()
                navigation.style.pointerEvents = "auto"
                bodyTag.style.overflow = "hidden"
            } else {
                hamburger.classList.remove("opened")
                tl.reverse().timeScale(-1.5)
                hambLottie.setDirection(-1);
                hambLottie.setSpeed(1.5)
                hambLottie.play()
                navigation.style.pointerEvents = "none"
                bodyTag.style.overflow = "auto"
            }
        })

        links.forEach(link => {
            link.addEventListener("click", function() {
                hamburger.classList.remove("opened")
                tl.reverse().timeScale(-2)
                hambLottie.setDirection(-1);
                hambLottie.setSpeed(1)
                hambLottie.play()
                navigation.style.pointerEvents = "none"
                bodyTag.style.overflow = "auto"                
            })
        })

    }    
    

}

// HIDE LOGO on scroll ==================================================================================
export function logoHide() {
    let letters = gsap.utils.toArray("#logo path:not(.letter-first)")
    let tl = gsap.timeline({
        scrollTrigger: {
            trigger: contentTag,
            start: "top -=200",
            toggleActions: "play none none reverse",
        },
    })
    tl.to("#logo .letter-first", {
        transformOrigin: "center left",
        scale: 2,
        duration: .4,
        ease: "power4.inOut"
    })
    tl.to(letters, {
        xPercent: -50,
        transformOrigin: "center left",
        scale: 0,
        duration: .4,
        stagger: {
            amount: .1,
            from: "start"
        },
        ease: "power4.inOut"
    }, "<")
    
}