export function textAnimations(){

    const fontLoadA = new FontFaceObserver('Thunder Black');
    const fontLoadB = new FontFaceObserver('Thunder Bold');
    const fontLoadC = new FontFaceObserver('Neue Montreal');
    const fontLoadD = new FontFaceObserver('Neue Montreal Bold');
    Promise.all([fontLoadA.load(), fontLoadB.load(), fontLoadC.load(), fontLoadD.load()]).then(function () {

        let splitChars = new SplitText(".split.chars", { type: "lines, chars" })
        let spitLines = new SplitText(".split.lines", { type: "lines" })
        gsap.set(".split", { perspective: 400, })

        // CHARS ANIMATION
        gsap.set(splitChars.chars, {
            transformOrigin: "0% 100%",
            y: "22%",
            scaleY: .2,
        })
        ScrollTrigger.batch(splitChars.chars, {
            start: "top 95%",
            onEnter: batch => gsap.to(batch, {
                transformOrigin: "0% 100%",
                duration: 1,
                stagger: {
                    amount: .2
                },
                y: "0%",
                scaleY: 1,
                ease: customEase
            }),
        });

        // LINES ANIMATION
        gsap.set(spitLines.lines, {
            opacity: 0,
            y: "150%"
        })
        ScrollTrigger.batch(spitLines.lines, {
            start: "top 95%",
            onEnter: batch => gsap.to(batch, {
                opacity: 1,
                duration: 1,
                y: 0,
                stagger: 0.03,
                ease: "expo.out"
            }),
            onLeaveBack: batch => gsap.to(batch, {
                opacity: 0,
                y: "150%",
                stagger: 0.03,
                ease: "power4"
            }),
        })

    });   
}